//
// Cforall Version 1.0.0 Copyright (C) 2015 University of Waterloo
//
// The contents of this file are covered under the licence agreement in the
// file "LICENCE" distributed with Cforall.
//
// BasicType.cc -- 
//
// Author           : Richard C. Bilson
// Created On       : Mon May 18 07:44:20 2015
// Last Modified By : Peter A. Buhr
// Last Modified On : Wed Feb  1 17:12:15 2017
// Update Count     : 8
//

#include <cassert>
#include "Type.h"

BasicType::BasicType( const Type::Qualifiers &tq, Kind bt, const std::list< Attribute * > & attributes ) : Type( tq, attributes ), kind( bt ) {}

void BasicType::print( std::ostream &os, int indent ) const {
	static const char *kindNames[] = {	
		"_Bool", "char", "signed char", "unsigned char", "short signed int", "short unsigned int",
		"signed int", "unsigned int", "long signed int", "long unsigned int", "long long signed int",
		"long long unsigned int", "float", "double", "long double", "float _Complex", "double _Complex",
		"long double _Complex", "float _Imaginary", "double _Imaginary", "long double _Imaginary"
	};

	Type::print( os, indent );
	os << kindNames[ kind ];
}

bool BasicType::isInteger() const {
	switch ( kind ) {
	  case Bool:
	  case Char:
	  case SignedChar:
	  case UnsignedChar:
	  case ShortSignedInt:
	  case ShortUnsignedInt:
	  case SignedInt:
	  case UnsignedInt:
	  case LongSignedInt:
	  case LongUnsignedInt:
	  case LongLongSignedInt:
	  case LongLongUnsignedInt:
		return true;
	  case Float:
	  case Double:
	  case LongDouble:
	  case FloatComplex:
	  case DoubleComplex:
	  case LongDoubleComplex:
	  case FloatImaginary:
	  case DoubleImaginary:
	  case LongDoubleImaginary:
		return false;
	  case NUMBER_OF_BASIC_TYPES:
		assert( false );
	} // switch
	assert( false );
	return false;
}


// Local Variables: //
// tab-width: 4 //
// mode: c++ //
// compile-command: "make install" //
// End: //
