//
// Cforall Version 1.0.0 Copyright (C) 2019 University of Waterloo
//
// The contents of this file are covered under the licence agreement in the
// file "LICENCE" distributed with Cforall.
//
// Heap.h --
//
// Author           : Thierry Delisle
// Created On       : Thu Feb 28 13::27:10 2019
// Last Modified By :
// Last Modified On :
// Update Count     :
//

#include "Counter.h"

#include <algorithm>
#include <cstring>
#include <iomanip>

namespace Stats {
	namespace Counters {

		template<typename T>
		void ForAllCounters(BaseCounter::list_t & range, size_t level, T func) {
			auto it = range.head;
			while(it) {
				auto next = it->next;
				func(it, level);
				ForAllCounters(it->children, level + 1, func);
				it = next;
			}
		}

		void print() {
			size_t nc = 0;
			ForAllCounters(BaseCounter::top, 0, [&](BaseCounter * node, size_t level) {
				nc = std::max(nc, (4 * level) + std::strlen(node->name));
			});

			const char * const title = "Counter Statistic";
			size_t nct = nc + 14;
			std::cerr << std::string(nct, '=') << std::endl;
			std::cerr << std::string((nct - std::strlen(title)) / 2, ' ');
			std::cerr << title << std::endl;
			std::cerr << std::string(nct, '-') << std::endl;


			ForAllCounters(BaseCounter::top, 0, [&](BaseCounter * node, size_t level) {
				std::cerr << std::string(level * 4, ' ');
				std::cerr << node->name;
				std::cerr << std::string(nc - ((level * 4) + std::strlen(node->name)), ' ');
				std::cerr << " | ";
				std::cerr << std::setw(9);
				node->print(std::cerr);
				std::cerr << " |";
				std::cerr << '\n';
				delete node;
			});

			std::cerr << std::string(nct, '-') << std::endl;
		}

		BaseCounter::list_t BaseCounter::top;
	}
}
