//
// Cforall Version 1.0.0 Copyright (C) 2019 University of Waterloo
//
// The contents of this file are covered under the licence agreement in the
// file "LICENCE" distributed with Cforall.
//
// Heap.h --
//
// Author           : Thierry Delisle
// Created On       : Thu Feb 28 12::05:10 2019
// Last Modified By :
// Last Modified On :
// Update Count     :
//

#pragma once

#include <cstdint>
#include <iostream>
#include <string>

#include "Common/Stats/Base.h"

namespace Stats {
	namespace Counters {
		void print();

		extern Base::TreeImpl::Top top;

		class CounterGroup : public Base::Tree<top> {
		public:
			CounterGroup(const std::string & name ) : Base::Tree<top>(name) {}
			CounterGroup(const std::string & name, Base::Tree<top> * parent) : Base::Tree<top>(name, parent) {}

			virtual void print(std::ostream & os) override { os << ""; }
		protected:
			virtual ~CounterGroup() = default;
		};

		class SimpleCounter : public Base::Tree<top> {
		public:
			SimpleCounter(const std::string & name ) : Base::Tree<top>(name) {}
			SimpleCounter(const std::string & name, Base::Tree<top> * parent) : Base::Tree<top>(name, parent) {}

			virtual void print(std::ostream & os) override { os << count; }

			inline void operator++(int)          { count++;        }
			inline void operator+=(size_t value) { count += value; }
		protected:
			virtual ~SimpleCounter() = default;

		private:
			size_t count = 0;
		};

		template<typename T>
		class AverageCounter : public Base::Tree<top> {
		public:
			AverageCounter(const std::string & name ) : Base::Tree<top>(name), sum{} {}
			AverageCounter(const std::string & name, Base::Tree<top> * parent) : Base::Tree<top>(name, parent), sum{} {}

			virtual void print(std::ostream & os) { os << sum / count; }

			inline void push(T value) {
				sum += value;
				count++;
			}

		protected:
			virtual ~AverageCounter() = default;

		private:
			T sum;
			size_t count = 1;
		};

		template<typename T>
		class MaxCounter : public Base::Tree<top> {
		public:
			MaxCounter(const std::string & name ) : Base::Tree<top>(name), max{} {}
			MaxCounter(const std::string & name, Base::Tree<top> * parent) : Base::Tree<top>(name, parent), max{} {}

			virtual void print(std::ostream & os) { os << max; }

			inline void push(T value) { max = std::max(max, value); }
		protected:
			virtual ~MaxCounter() = default;

		private:
			T max;
		};
	}
}
