//
// Cforall Version 1.0.0 Copyright (C) 2015 University of Waterloo
//
// The contents of this file are covered under the licence agreement in the
// file "LICENCE" distributed with Cforall.
//
// HoistControlDecls.cpp -- Desugar Cforall control structures.
//
// Author           : Andrew Beach
// Created On       : Fri Dec  3 15:34:00 2021
// Last Modified By : Andrew Beach
// Last Modified On : Fri Dec  3 15:34:00 2021
// Update Count     : 0
//

#include "HoistControlDecls.hpp"

#include "AST/Decl.hpp"
#include "AST/Pass.hpp"
#include "AST/TranslationUnit.hpp"

namespace ControlStruct {

namespace {

template<typename StmtT>
const ast::Stmt * hoist( const StmtT * stmt ) {
	// If no hoisting is needed, then make no changes.
	if ( 0 == stmt->inits.size() ) {
		return stmt;
	}

	// Put initializers and the old statement in the compound statement.
	ast::CompoundStmt * block = new ast::CompoundStmt( stmt->location );
	StmtT * mutStmt = ast::mutate( stmt );
	for ( const ast::Stmt * next : mutStmt->inits ) {
		block->kids.push_back( next );
	}
	mutStmt->inits.clear();
	block->kids.push_back( mutStmt );
	return block;
}

struct HoistControlCore {
	const ast::Stmt * postvisit( const ast::IfStmt * stmt ) {
		return hoist<ast::IfStmt>( stmt );
	}
	const ast::Stmt * postvisit( const ast::ForStmt * stmt ) {
		return hoist<ast::ForStmt>( stmt );
	}
	const ast::Stmt * postvisit( const ast::WhileStmt * stmt ) {
		return hoist<ast::WhileStmt>( stmt );
	}
};

} // namespace

/// Hoist initialization out of for statements.
void hoistControlDecls( ast::TranslationUnit & translationUnit ) {
	ast::Pass<HoistControlCore>::run( translationUnit );
}

} // namespace ControlStruct

// Local Variables: //
// tab-width: 4 //
// mode: c++ //
// compile-command: "make install" //
// End: //
