//
// Cforall Version 1.0.0 Copyright (C) 2016 University of Waterloo
//
// The contents of this file are covered under the licence agreement in the
// file "LICENCE" distributed with Cforall.
//
// builtins.c --
//
// Author           : Peter A. Buhr
// Created On       : Fri Jul 21 16:21:03 2017
// Last Modified By : Peter A. Buhr
// Last Modified On : Tue Mar 26 14:05:49 2019
// Update Count     : 84
//

// exception implementation

typedef unsigned long long __cfaabi_abi_exception_type_t;

#include "../src/virtual.h"
#include "../src/exception.h"

void exit( int status, const char fmt[], ... ) __attribute__ (( format(printf, 2, 3), __nothrow__, __leaf__, __noreturn__ ));
void abort( const char fmt[], ... ) __attribute__ (( format(printf, 1, 2), __nothrow__, __leaf__, __noreturn__ ));

// increment/decrement unification

static inline forall( dtype DT | { DT & ?+=?( DT &, one_t ); } )
DT & ++?( DT & x ) { return x += 1; }

static inline forall( dtype DT | sized(DT) | { void ?{}( DT &, DT ); void ^?{}( DT & ); DT & ?+=?( DT &, one_t ); } )
DT & ?++( DT & x ) { DT tmp = x; x += 1; return tmp; }

static inline forall( dtype DT | { DT & ?-=?( DT &, one_t ); } )
DT & --?( DT & x ) { return x -= 1; }

static inline forall( dtype DT | sized(DT) | { void ?{}( DT &, DT ); void ^?{}( DT & ); DT & ?-=?( DT &, one_t ); } )
DT & ?--( DT & x ) { DT tmp = x; x -= 1; return tmp; }

// universal typed pointer constant

// Compiler issue: there is a problem with anonymous types that do not have  a size.
static inline forall( dtype DT | sized(DT) ) DT * intptr( uintptr_t addr ) { return (DT *)addr; }

// exponentiation operator implementation

extern "C" {
	float powf( float x, float y );
	double pow( double x, double y );
	long double powl( long double x, long double y );
	float _Complex cpowf( float _Complex x, _Complex float z );
	double _Complex cpow( double _Complex x, _Complex double z );
	long double _Complex cpowl( long double _Complex x, _Complex long double z );
} // extern "C"

static inline float ?\?( float x, float y ) { return powf( x, y ); }
static inline double ?\?( double x, double y ) { return pow( x, y ); }
static inline long double ?\?( long double x, long double y ) { return powl( x, y ); }
static inline float _Complex ?\?( float _Complex x, _Complex float y ) { return cpowf(x, y ); }
static inline double _Complex ?\?( double _Complex x, _Complex double y ) { return cpow( x, y ); }
static inline long double _Complex ?\?( long double _Complex x, _Complex long double y ) { return cpowl( x, y ); }

#define __CFA_EXP__() \
	if ( y == 0 ) return 1;								/* base case */ \
	__CFA_BASE_COMP_1__()								/* base case */ \
	__CFA_BASE_COMP_2__()								/* special case, positive shifting for integral types */ \
	__CFA_EXP_OVERFLOW__()								/* immediate overflow, negative exponent > 2^size-1 */ \
	typeof(ep) op = 1;									/* accumulate odd product */ \
	for ( ; y > 1; y >>= 1 ) {							/* squaring exponentiation, O(log2 y) */ \
		if ( (y & 1) == 1 ) op = op * ep;				/* odd ? */ \
		ep = ep * ep; \
	} \
	return ep * op

#define __CFA_BASE_COMP_1__() if ( ep == 1 ) return 1;
#define __CFA_BASE_COMP_2__() if ( ep == 2 ) return ep << (y - 1);
#define __CFA_EXP_OVERFLOW__() if ( y >= sizeof(y) * 8 ) return 0;

static inline long int ?\?( int ep, unsigned int y ) {
	__CFA_EXP__();
} // ?\?

static inline long int ?\?( long int ep, unsigned long int y ) {
	__CFA_EXP__();
} // ?\?

// unsigned computation may be faster and larger
static inline unsigned long int ?\?( unsigned int ep, unsigned int y ) {
	__CFA_EXP__();
} // ?\?

static inline unsigned long int ?\?( unsigned long int ep, unsigned long int y ) {
	__CFA_EXP__();
} // ?\?

#undef __CFA_BASE_COMP_1__
#undef __CFA_BASE_COMP_2__
#undef __CFA_EXP_OVERFLOW__
#define __CFA_BASE_COMP_1__()
#define __CFA_BASE_COMP_2__()
#define __CFA_EXP_OVERFLOW__()

static inline forall( otype OT | { void ?{}( OT & this, one_t ); OT ?*?( OT, OT ); } )
OT ?\?( OT ep, unsigned int y ) {
	__CFA_EXP__();
} // ?\?

static inline forall( otype OT | { void ?{}( OT & this, zero_t ); void ?{}( OT & this, one_t ); int ?==?( OT, OT ); OT ?*?( OT, OT ); } )
OT ?\?( OT ep, unsigned long int y ) {
	__CFA_EXP__();
} // ?\?

#undef __CFA_BASE_COMP_1__
#undef __CFA_BASE_COMP_2__
#undef __CFA_EXP_OVERFLOW__

static inline long int ?\=?( long int & x, unsigned long int y ) { x = x \ y; return x; }
static inline unsigned long int ?\=?( unsigned long int & x, unsigned long int y ) { x = x \ y; return x; }
static inline int ?\=?( int & x, unsigned long int y ) { x = x \ y; return x; }
static inline unsigned int ?\=?( unsigned int & x, unsigned long int y ) { x = x \ y; return x; }

// Local Variables: //
// mode: c //
// tab-width: 4 //
// End: //
