#include <fstream>
#include <stdlib>
#include <thread>

#include "bench.h"

coroutine GreatSuspender {};

void ?{}( GreatSuspender * this ) {
	prime(this);
}

void main( GreatSuspender * this )
{
	while( true ) {
		suspend();
	}
}

void resumer( GreatSuspender * this, const unsigned int NoOfTimes ) {
	for ( volatile unsigned int i = 0; i < NoOfTimes; i += 1 ) {
		resume( this );
	}
}

#ifndef N
#define N 100000000
#endif



long long int measure_coroutine() {
	const unsigned int NoOfTimes = N;
	long long int StartTime, EndTime;

	GreatSuspender s;

	StartTime = Time();
	// for ( volatile unsigned int i = 0; i < NoOfTimes; i += 1 ) {
	// 	resume( this_coroutine() );
	// 	// resume( &s );
	// }
	resumer( &s, NoOfTimes );
	EndTime = Time();

	return ( EndTime - StartTime ) / NoOfTimes;
}

long long int measure_thread() {
	const unsigned int NoOfTimes = N;
	long long int StartTime, EndTime;

	StartTime = Time();
	for ( volatile unsigned int i = 0; i < NoOfTimes; i += 1 ) {
		yield();
	}
	EndTime = Time();

	return ( EndTime - StartTime ) / NoOfTimes;
}

int main()
{
	sout | time(NULL) | ',' | measure_coroutine() | ',' | measure_thread() | endl;
}
