#!/usr/bin/python

import sys
import numpy

if len(sys.argv) != 2 :
	sys.exit("Expected file name as only argument")

try:
	with open(sys.argv[1]) as f:
		content = f.readlines()
		content = [x.strip() for x in content]
		content = [float(x) for x in content]	# expect floating-point strings
		content.remove(max(content))		# need at least 4 data values because
		content.remove(min(content))		# the max and min values are removed
		med = numpy.median(content)
		avg = numpy.mean  (content)
		std = numpy.std   (content)
		print "median {0:.1f} avg {1:.1f} stddev {2:.1f}".format( med, avg, std )


except IOError as e:
	sys.exit(e.strerror)
