//
// Cforall Version 1.0.0 Copyright (C) 2015 University of Waterloo
//
// The contents of this file are covered under the licence agreement in the
// file "LICENCE" distributed with Cforall.
//
// LinkageSpec.cc -- 
// 
// Author           : Rodolfo G. Esteves
// Created On       : Sat May 16 13:22:09 2015
// Last Modified By : Peter A. Buhr
// Last Modified On : Thu Aug 18 23:47:14 2016
// Update Count     : 12
// 

#include <string>
#include <cassert>

#include "LinkageSpec.h"
#include "Common/SemanticError.h"

LinkageSpec::Spec LinkageSpec::fromString( const std::string &stringSpec ) {
	if ( stringSpec == "\"Cforall\"" ) {
		return Cforall;
	} else if ( stringSpec == "\"C\"" ) {
		return C;
	} else {
		throw SemanticError( "Invalid linkage specifier " + stringSpec );
	}
}

std::string LinkageSpec::toString( LinkageSpec::Spec linkage ) {
	static const char *linkageKinds[LinkageSpec::NoOfSpecs] = {
		"intrinsic", "Cforall", "C", "automatically generated", "compiler built-in",
	};
	return linkageKinds[linkage];
}

bool LinkageSpec::isDecoratable( Spec t ) {
	static bool decoratable[LinkageSpec::NoOfSpecs] = {
		//	Intrinsic,	Cforall,	C,		AutoGen,	Compiler
			true,		true,		false,	true,		false, 
	};
	return decoratable[t];
}

bool LinkageSpec::isGeneratable( Spec t ) {
	static bool generatable[LinkageSpec::NoOfSpecs] = {
		//	Intrinsic,	Cforall,	C,		AutoGen,	Compiler
			true,		true,		true,	true,		false, 
	};
	return generatable[t];
}

bool LinkageSpec::isOverloadable( Spec t ) {
	return isDecoratable( t );
}


bool LinkageSpec::isOverridable( Spec t ) {
	static bool overridable[LinkageSpec::NoOfSpecs] = {
		//	Intrinsic,	Cforall,	C,		AutoGen,	Compiler
			true,		false,		false,	true,		false, 
	};
	return overridable[t];
}

bool LinkageSpec::isBuiltin( Spec t ) {
	static bool builtin[LinkageSpec::NoOfSpecs] = {
		//	Intrinsic,	Cforall,	C,		AutoGen,	Compiler
			true,		false,		false,	false,		true, 
	};
	return builtin[t];
}

// Local Variables: //
// tab-width: 4 //
// mode: c++ //
// compile-command: "make install" //
// End: //
