// 
// Cforall Version 1.0.0 Copyright (C) 2015 University of Waterloo
//
// The contents of this file are covered under the licence agreement in the
// file "LICENCE" distributed with Cforall.
// 
// Assert.cc -- 
// 
// Author           : Peter A. Buhr
// Created On       : Thu Aug 18 13:26:59 2016
// Last Modified By : Peter A. Buhr
// Last Modified On : Thu Aug 18 23:40:29 2016
// Update Count     : 8
// 

#include <assert.h>
#include <cstdarg>
#include <cstdio>
#include <cstdlib>

extern const char * __progname;							// global name of running executable (argv[0])

#define CFA_ASSERT_FMT "*CFA assertion error* from program \"%s\" in \"%s\" at line %d in file \"%s\""

// called by macro assert in assert.h
void __assert_fail( const char *assertion, const char *file, unsigned int line, const char *function ) {
	fprintf( stderr, CFA_ASSERT_FMT ".\n", __progname, function, line, file );
	exit( EXIT_FAILURE );
}

// called by macro assertf
void __assert_fail_f( const char *assertion, const char *file, unsigned int line, const char *function, const char *fmt, ... ) {
	fprintf( stderr, CFA_ASSERT_FMT ": ", __progname, function, line, file );
	va_list args;
	va_start( args, fmt );
	vfprintf( stderr, fmt, args );
	exit( EXIT_FAILURE );
}

// Local Variables: //
// tab-width: 4 //
// mode: c++ //
// compile-command: "make install" //
// End:  //

