package main

import (
    "fmt"
    "runtime"
    "time"
)

//=======================================
// time context switch
//=======================================

var shake chan bool = make( chan bool )

func ContextSwitch(N int) {
	start := time.Now()
	for i := 1; i <= N; i += 1 {
		runtime.Gosched()
	}
	end := time.Now()
	fmt.Printf("%d\n", end.Sub(start) / time.Duration(N))
	shake <- true   // indicate completion
}

//=======================================
// benchmark driver
//=======================================

func main() {
	const NoOfTimes = 10000000
	go ContextSwitch( NoOfTimes )		// context switch
	<- shake
}
