package main

import (
    "fmt"
    "time"
)

var shake chan bool = make( chan bool )

func noop() {
	shake <- true   // indicate completion
}

//=======================================
// benchmark driver
//=======================================

func main() {
	const NoOfTimes = 500000
	start := time.Now()
	for i := 1; i <= NoOfTimes; i += 1 {
		go noop()		// creation
	}
	end := time.Now()
	fmt.Printf("%d\n", end.Sub(start) / time.Duration(NoOfTimes))
	<- shake
}
