//
// Cforall Version 1.0.0 Copyright (C) 2015 University of Waterloo
//
// The contents of this file are covered under the licence agreement in the
// file "LICENCE" distributed with Cforall.
//
// Visitor.h --
//
// Author           : Richard C. Bilson
// Created On       : Mon May 18 07:44:20 2015
// Last Modified By : Peter A. Buhr
// Last Modified On : Wed Aug  3 17:01:50 2016
// Update Count     : 9
//

#ifndef VISITOR_H
#define VISITOR_H

#include "SynTree.h"
#include "Common/SemanticError.h"
#include "Common/CompilerError.h"

class Visitor {
  protected:
	Visitor();
	virtual ~Visitor();
  public:
	virtual void visit( ObjectDecl *objectDecl );
	virtual void visit( FunctionDecl *functionDecl );
	virtual void visit( StructDecl *aggregateDecl );
	virtual void visit( UnionDecl *aggregateDecl );
	virtual void visit( EnumDecl *aggregateDecl );
	virtual void visit( TraitDecl *aggregateDecl );
	virtual void visit( TypeDecl *typeDecl );
	virtual void visit( TypedefDecl *typeDecl );

	virtual void visit( CompoundStmt *compoundStmt );
	virtual void visit( ExprStmt *exprStmt );
	virtual void visit( AsmStmt *asmStmt );
	virtual void visit( IfStmt *ifStmt );
	virtual void visit( WhileStmt *whileStmt );
	virtual void visit( ForStmt *forStmt );
	virtual void visit( SwitchStmt *switchStmt );
	virtual void visit( CaseStmt *caseStmt );
	virtual void visit( BranchStmt *branchStmt );
	virtual void visit( ReturnStmt *returnStmt );
	virtual void visit( TryStmt *tryStmt );
	virtual void visit( CatchStmt *catchStmt );
	virtual void visit( FinallyStmt *finallyStmt );
	virtual void visit( NullStmt *nullStmt );
	virtual void visit( DeclStmt *declStmt );
	virtual void visit( ImplicitCtorDtorStmt *impCtorDtorStmt );

	virtual void visit( ApplicationExpr *applicationExpr );
	virtual void visit( UntypedExpr *untypedExpr );
	virtual void visit( NameExpr *nameExpr );
	virtual void visit( CastExpr *castExpr );
	virtual void visit( AddressExpr *addressExpr );
	virtual void visit( LabelAddressExpr *labAddressExpr );
	virtual void visit( UntypedMemberExpr *memberExpr );
	virtual void visit( MemberExpr *memberExpr );
	virtual void visit( VariableExpr *variableExpr );
	virtual void visit( ConstantExpr *constantExpr );
	virtual void visit( SizeofExpr *sizeofExpr );
	virtual void visit( AlignofExpr *alignofExpr );
	virtual void visit( UntypedOffsetofExpr *offsetofExpr );
	virtual void visit( OffsetofExpr *offsetofExpr );
	virtual void visit( OffsetPackExpr *offsetPackExpr );
	virtual void visit( AttrExpr *attrExpr );
	virtual void visit( LogicalExpr *logicalExpr );
	virtual void visit( ConditionalExpr *conditionalExpr );
	virtual void visit( CommaExpr *commaExpr );
	virtual void visit( TupleExpr *tupleExpr );
	virtual void visit( SolvedTupleExpr *tupleExpr );
	virtual void visit( TypeExpr *typeExpr );
	virtual void visit( AsmExpr *asmExpr );
	virtual void visit( ImplicitCopyCtorExpr *impCpCtorExpr );
	virtual void visit( ConstructorExpr * ctorExpr );
	virtual void visit( CompoundLiteralExpr *compLitExpr );
	virtual void visit( UntypedValofExpr *valofExpr );
	virtual void visit( RangeExpr *rangeExpr );

	virtual void visit( VoidType *basicType );
	virtual void visit( BasicType *basicType );
	virtual void visit( PointerType *pointerType );
	virtual void visit( ArrayType *arrayType );
	virtual void visit( FunctionType *functionType );
	virtual void visit( StructInstType *aggregateUseType );
	virtual void visit( UnionInstType *aggregateUseType );
	virtual void visit( EnumInstType *aggregateUseType );
	virtual void visit( TraitInstType *aggregateUseType );
	virtual void visit( TypeInstType *aggregateUseType );
	virtual void visit( TupleType *tupleType );
	virtual void visit( TypeofType *typeofType );
	virtual void visit( AttrType *attrType );
	virtual void visit( VarArgsType *varArgsType );
	virtual void visit( ZeroType *zeroType );
	virtual void visit( OneType *oneType );

	virtual void visit( SingleInit *singleInit );
	virtual void visit( ListInit *listInit );
	virtual void visit( ConstructorInit *ctorInit );

	virtual void visit( Subrange *subrange );

	virtual void visit( Constant *constant );
  private:
	virtual void handleAggregateDecl( AggregateDecl *aggregateDecl );
	virtual void handleNamedTypeDecl( NamedTypeDecl *typeDecl );
	virtual void handleReferenceToType( ReferenceToType *aggregateUseType );
};

template< typename TreeType, typename VisitorType >
inline void maybeAccept( TreeType *tree, VisitorType &visitor ) {
	if ( tree ) {
		tree->accept( visitor );
	}
}

template< typename Container, typename VisitorType >
inline void acceptAll( Container &container, VisitorType &visitor ) {
	SemanticError errors;
	for ( typename Container::iterator i = container.begin(); i != container.end(); ++i ) {
		try {
			if ( *i ) {
				(*i)->accept( visitor );
			}
		} catch( SemanticError &e ) {
			errors.append( e );
		}
	}
	if ( ! errors.isEmpty() ) {
		throw errors;
	}
}

template< typename Container, typename VisitorType >
void acceptAllFold( Container &container, VisitorType &visitor, VisitorType &around ) {
	SemanticError errors;
	for ( typename Container::iterator i = container.begin(); i != container.end(); ++i ) {
		try {
			if ( *i ) {
				VisitorType *v = new VisitorType;
				(*i)->accept( *v );

				typename Container::iterator nxt = i; nxt++; // forward_iterator
				if ( nxt == container.end() )
					visitor += *v;
				else
					visitor += *v + around;

				delete v;
			} // if
		} catch( SemanticError &e ) {
			errors.append( e );
		} // try
	} // for
	if ( ! errors.isEmpty() ) {
		throw errors;
	} // if
}

#endif // VISITOR_H

// Local Variables: //
// tab-width: 4 //
// mode: c++ //
// compile-command: "make install" //
// End: //
