//
// Cforall Version 1.0.0 Copyright (C) 2015 University of Waterloo
//
// The contents of this file are covered under the licence agreement in the
// file "LICENCE" distributed with Cforall.
//
// VarExprReplacer.h --
//
// Author           : Rob Schluntz
// Created On       : Wed Jan 13 16:29:30 2016
// Last Modified By : Rob Schluntz
// Last Modified On : Fri May 13 11:27:52 2016
// Update Count     : 5
//

#include <iostream>       // for operator<<, basic_ostream, ostream, basic_o...

#include "Common/PassVisitor.h"
#include "Declaration.h"  // for operator<<, DeclarationWithType
#include "Expression.h"   // for VariableExpr
#include "VarExprReplacer.h"

namespace VarExprReplacer {
	namespace {
		/// Visitor that replaces the declarations that VariableExprs refer to, according to the supplied mapping
		struct VarExprReplacer {
		private:
			const DeclMap & declMap;
			bool debug;
		public:
			VarExprReplacer( const DeclMap & declMap, bool debug = false );

			// replace variable with new node from decl map
			void previsit( VariableExpr * varExpr );
		};
	}

	void replace( BaseSyntaxNode * node, const DeclMap & declMap, bool debug ) {
		PassVisitor<VarExprReplacer> replacer( declMap, debug );
		maybeAccept( node, replacer );
	}

	namespace {
		VarExprReplacer::VarExprReplacer( const DeclMap & declMap, bool debug ) : declMap( declMap ), debug( debug ) {}

		// replace variable with new node from decl map
		void VarExprReplacer::previsit( VariableExpr * varExpr ) {
			// xxx - assertions and parameters aren't accounted for in this... (i.e. they aren't inserted into the map when it's made, only DeclStmts are)
			if ( declMap.count( varExpr->var ) ) {
				if ( debug ) {
					std::cerr << "replacing variable reference: " << (void*)varExpr->var << " " << varExpr->var << " with " << (void*)declMap.at( varExpr->var ) << " " << declMap.at( varExpr->var ) << std::endl;
				}
				varExpr->var = declMap.at( varExpr->var );
			}
		}
	}
} // namespace VarExprReplacer







