//
// Cforall Version 1.0.0 Copyright (C) 2015 University of Waterloo
//
// The contents of this file are covered under the licence agreement in the
// file "LICENCE" distributed with Cforall.
//
// Attribute.cc --
//
// Author           : Rob Schluntz
// Created On       : Mon June 06 14:51:16 2016
// Last Modified By : Rob Schluntz
// Last Modified On : Mon June 06 14:54:48 2016
// Update Count     : 1
//

#include <ostream>           // for operator<<, ostream, basic_ostream, endl

#include "Attribute.h"
#include "Common/utility.h"  // for cloneAll, deleteAll, printAll
#include "Expression.h"      // for Expression

Attribute::Attribute( const Attribute &other ) : name( other.name ) {
  cloneAll( other.parameters, parameters );
}

Attribute::~Attribute() {
  deleteAll( parameters );
}

void Attribute::print( std::ostream &os, Indenter indent ) const {
  using std::endl;
  using std::string;

  if ( ! empty() ) {
    os << "Attribute with name: " << name;
    if ( ! parameters.empty() ) {
      os << " with parameters: " << endl;
      printAll( parameters, os, indent+1 );
    }
  }
}

// Local Variables: //
// tab-width: 4 //
// mode: c++ //
// compile-command: "make install" //
// End: //
