#include <stdlib>

extern "C" {
	#include <stdio.h>
}

#include <containers/vector>

#define assert(x) do {\
	if(!(x)) {\
		printf("CHECK failed : %s at %s:%i\n", #x, __FILE__, __LINE__);\
		abort();\
	}}while(0 == 1)\

int main(int argc, char const *argv[]) {
	vector(int, heap_allocator(int)) iv;
	ctor(&iv);

	assert(empty(&iv));
	assert(size(&iv) == 0);
	printf("%d\n", size(&iv));

	push_back(&iv, 1);
	printf("%d\n", size(&iv));
	assert(size(&iv) == 1);
	push_back(&iv, 2);
	printf("%d\n", size(&iv));
	assert(size(&iv) == 2);
	push_back(&iv, 3);
	printf("%d\n", size(&iv));
	assert(size(&iv) == 3);

	assert(!empty(&iv));
	assert(size(&iv) == 3);
	assert(at(&iv, 0) == 1);
	assert((&iv)[0] == 1);
	assert(at(&iv, 1) == 2);
	assert((&iv)[1] == 2);
	assert(at(&iv, 2) == 3);
	assert((&iv)[2] == 3);

	clear(&iv);

	assert(empty(&iv));
	assert(size(&iv) == 0);
	printf("%d\n", size(&iv));

	return 0;
}
