#include <algorithm>
#include <stdlib.h>
#include "bench.hpp"
#include "cpp-vstack.hpp"
#include "object.hpp"

int main(int argc, char** argv) {
	srand(20171025);

	stack s;
	REPEAT_TIMED( "push_int",
		s.push( std::make_unique<integer>( rand() ) );
	)

	stack t;
	TIMED( "copy_int", 
		t = s;
	)

	TIMED( "clear_int", 
		s.clear();
	)

	integer max;
	REPEAT_TIMED( "pop_int",
		max = std::max( max, t.pop()->as<integer>() );
	)

	stack s2;
	REPEAT_TIMED( "push_bool_char",
		s2.push( std::make_unique<pair>( std::make_unique<boolean>( rand() & 0x1 ), 
			std::make_unique<character>( rand() & 0x7F ) ) );
	)

	stack t2;
	TIMED( "copy_bool_char", 
		t2 = s2;
	)

	TIMED( "clear_bool_char", 
		s2.clear();
	)

	pair max2 = { std::make_unique<boolean>(false), std::make_unique<character>('\0') };
	REPEAT_TIMED( "pop_bool_char",
		max2 = std::max( max2, t2.pop()->as<pair>() );
	)
}
