#include <algorithm>
#include <stdlib.h>
#include <utility>
#include "bench.hpp"
#include "cpp-stack.hpp"

int main(int argc, char** argv) {
	srand(20171025);

	stack<int> s;
	REPEAT_TIMED( "push_int",
		s.push( rand() );
	)

	stack<int> t;
	TIMED( "copy_int", 
		t = s;
	)

	TIMED( "clear_int", 
		s.clear();
	)

	int max = 0;
	REPEAT_TIMED( "pop_int",
		max = std::max( max, t.pop() );
	)

	stack<std::pair<bool, char>> s2;
	REPEAT_TIMED( "push_bool_char",
		s2.push( std::pair<bool, char>{ rand() & 0x1, rand() & 0x7F } );
	)

	stack<std::pair<bool,char>> t2;
	TIMED( "copy_bool_char", 
		t2 = s2;
	)

	TIMED( "clear_bool_char", 
		s2.clear();
	)

	std::pair<bool, char> max2 = { false, '\0' };
	REPEAT_TIMED( "pop_bool_char",
		max2 = std::max( max2, t2.pop() );
	)
}