#include <stdlib.h>
#include "c-pair.h"

struct pair* new_pair(void* first, void* second) {
	struct pair* p = malloc(sizeof(struct pair));
	*p = (struct pair){ first, second };
	return p;
}

struct pair* copy_pair(const struct pair* src, 
		void* (*copy_first)(const void*), void* (*copy_second)(const void*)) {
	return new_pair( copy_first(src->first), copy_second(src->second) );
}

void free_pair(struct pair* p, void (*free_first)(void*), void (*free_second)(void*)) {
	free_first(p->first);
	free_second(p->second);
	free(p);
}

int cmp_pair(const struct pair* a, const struct pair* b, 
		int (*cmp_first)(const void*, const void*), int (*cmp_second)(const void*, const void*)) {
	int c = cmp_first(a->first, b->first);
	if ( c == 0 ) c = cmp_second(a->second, b->second);
	return c;
}
