//
// Cforall Version 1.0.0 Copyright (C) 2015 University of Waterloo
//
// The contents of this file are covered under the licence agreement in the
// file "LICENCE" distributed with Cforall.
//
// AddStmtVisitor.h --
//
// Author           : Rob Schluntz
// Created On       : Wed Jun 22 12:05:48 2016
// Last Modified By : Rob Schluntz
// Last Modified On : Wed Jun 22 12:12:05 2016
// Update Count     : 7
//

#ifndef ADD_STATEMENT_VISITOR_H
#define ADD_STATEMENT_VISITOR_H

#include <list>

#include "SynTree/SynTree.h"
#include "SynTree/Visitor.h"

class AddStmtVisitor : public Visitor {
  public:
	typedef Visitor Parent;

	using Parent::visit;
	virtual void visit(CompoundStmt *compoundStmt);
	virtual void visit(IfStmt *ifStmt);
	virtual void visit(WhileStmt *whileStmt);
	virtual void visit(ForStmt *forStmt);
	virtual void visit(SwitchStmt *switchStmt);
	virtual void visit(ChooseStmt *chooseStmt);
	virtual void visit(CaseStmt *caseStmt);
	virtual void visit(CatchStmt *catchStmt);

  protected:
	void visitStatementList( std::list< Statement * > & );
	Statement * visitStatement( Statement * );
	std::list< Statement* > stmtsToAdd;
	std::list< Statement* > stmtsToAddAfter;
};

#endif // ADD_STATEMENT_VISITOR_H
