//
// Cforall Version 1.0.0 Copyright (C) 2019 University of Waterloo
//
// The contents of this file are covered under the licence agreement in the
// file "LICENCE" distributed with Cforall.
//
// Time.h --
//
// Author           : Thierry Delisle
// Created On       : Fri Mar 01 15:14:11 2019
// Last Modified By :
// Last Modified On :
// Update Count     :
//

#pragma once

#include "Common/Stats/Base.h"

namespace Stats {
	namespace Time {
		void StartBlock(const char * const name);
		void StopBlock();

		void print();

		struct BlockGuard {
			BlockGuard(const char * const name ) { StartBlock(name); }
			~BlockGuard() { StopBlock(); }
		};

		template<typename func_t>
		void TimeBLock(const char * name, func_t func) {
			BlockGuard guard(name);
			func();
		}
	}
}