//
// Cforall Version 1.0.0 Copyright (C) 2015 University of Waterloo
//
// The contents of this file are covered under the licence agreement in the
// file "LICENCE" distributed with Cforall.
//
// iterator.c -- 
//
// Author           : Richard C. Bilson
// Created On       : Wed May 27 17:56:53 2015
// Last Modified By : Peter A. Buhr
// Last Modified On : Wed May 27 18:41:41 2015
// Update Count     : 3
//

#include "iterator.h"

/// forall( type iterator_type, type elt_type | iterator( iterator_type, elt_type ) )
/// void
/// for_each( iterator_type begin, iterator_type end, void (*func)( elt_type ) )
/// {
///   iterator_type i;
///   for ( i = begin; i != end; ++i ) {
///	 func( *i );
///   }
/// }

forall( type elt_type | writeable( elt_type ),
		type iterator_type | iterator( iterator_type, elt_type ),
		dtype os_type | ostream( os_type ) )
void write_all( iterator_type begin, iterator_type end, os_type *os ) {
	iterator_type i;
	for ( i = begin; i != end; ++i ) {
		os << *i << ' ';
	}
}

forall( type elt_type | writeable( elt_type ),
		type iterator_type | iterator( iterator_type, elt_type ),
		dtype os_type | ostream( os_type ) )
void write_reverse( iterator_type begin, iterator_type end, os_type *os ) {
	iterator_type i; // "= end;" does not work
	i = end;
	do {
		--i;
		os << *i << ' ';
	} while ( i != begin );
}

// Local Variables: //
// tab-width: 4 //
// compile-command: "cfa iterator.c" //
// End: //
