//
// Cforall Version 1.0.0 Copyright (C) 2015 University of Waterloo
//
// The contents of this file are covered under the licence agreement in the
// file "LICENCE" distributed with Cforall.
//
// Validate.h -- This class is intended to perform pre-processing of declarations, validating their correctness and
//               computing some auxilliary data that is necessary for the indexer.
//
// Author           : Richard C. Bilson
// Created On       : Sun May 17 21:53:34 2015
// Last Modified By : Peter A. Buhr
// Last Modified On : Tue May 19 16:49:43 2015
// Update Count     : 3
//

#ifndef VALIDATE_H
#define VALIDATE_H

#include "SynTree/SynTree.h"

namespace SymTab {
	class Indexer;

	void validate( std::list< Declaration * > &translationUnit, bool doDebug = false );
	void validateType( Type *type, const Indexer *indexer );
} // namespace SymTab

#endif // VALIDATE_H

// Local Variables: //
// tab-width: 4 //
// mode: c++ //
// compile-command: "make install" //
// End: //
