//
// Cforall Version 1.0.0 Copyright (C) 2015 University of Waterloo
//
// The contents of this file are covered under the licence agreement in the
// file "LICENCE" distributed with Cforall.
//
// StackTable.h -- 
//
// Author           : Richard C. Bilson
// Created On       : Sun May 17 21:47:10 2015
// Last Modified By : Peter A. Buhr
// Last Modified On : Tue May 19 16:50:36 2015
// Update Count     : 4
//

#ifndef STACKTABLE_H
#define STACKTABLE_H

#include <map>
#include <stack>
#include <string>
#include <functional>

namespace SymTab {
	template< typename Element, typename ConflictFunction >
	class StackTable {
	  public:
		StackTable();

		void enterScope();
		void leaveScope();
		void add( Element *type );
		void add( std::string fwdDeclName );
		Element *lookup( std::string id ) const;

		void dump( std::ostream &os ) const;			// debugging
	  private:
		typedef std::pair< Element*, int > Entry;
		typedef std::map< std::string, std::stack< Entry > > TableType;
  
		ConflictFunction conflictFunction;
		TableType table;
		int scopeLevel;
	};
} // SymTab

#include "StackTable.cc"

#endif // STACKTABLE_H

// Local Variables: //
// tab-width: 4 //
// mode: c++ //
// compile-command: "make install" //
// End: //
