//
// Cforall Version 1.0.0 Copyright (C) 2015 University of Waterloo
//
// The contents of this file are covered under the licence agreement in the
// file "LICENCE" distributed with Cforall.
//
// Mangler.h -- 
//
// Author           : Richard C. Bilson
// Created On       : Sun May 17 21:44:03 2015
// Last Modified By : Peter A. Buhr
// Last Modified On : Tue May 19 16:49:21 2015
// Update Count     : 3
//

#ifndef MANGLER_H
#define MANGLER_H

#include <strstream>
#include "SynTree/SynTree.h"
#include "SynTree/Visitor.h"

namespace SymTab {
	class Mangler : public Visitor {
	  public:
		template< typename SynTreeClass >
	    static std::string mangle( SynTreeClass *decl ); // interface to clients

///   using Visitor::visit;
		virtual void visit( ObjectDecl *declaration );
		virtual void visit( FunctionDecl *declaration );
		virtual void visit( TypeDecl *declaration );

		virtual void visit( VoidType *voidType );
		virtual void visit( BasicType *basicType );
		virtual void visit( PointerType *pointerType );
		virtual void visit( ArrayType *arrayType );
		virtual void visit( FunctionType *functionType );
		virtual void visit( StructInstType *aggregateUseType );
		virtual void visit( UnionInstType *aggregateUseType );
		virtual void visit( EnumInstType *aggregateUseType );
		virtual void visit( TypeInstType *aggregateUseType );
		virtual void visit( TupleType *tupleType );
  
		std::string get_mangleName() { return std::string( mangleName.str(), mangleName.pcount() ); }
	  private:
		std::ostrstream mangleName;
		typedef std::map< std::string, std::pair< int, int > > VarMapType;
		VarMapType varNums;
		int nextVarNum;
		bool isTopLevel;
  
		Mangler();
		Mangler( const Mangler & );
  
		void mangleDecl( DeclarationWithType *declaration );
		void mangleRef( ReferenceToType *refType, std::string prefix );
  
		void printQualifiers( Type *type );
	}; // Mangler

	template< typename SynTreeClass >
	std::string Mangler::mangle( SynTreeClass *decl ) {
		Mangler mangler;
		maybeAccept( decl, mangler );
		return mangler.get_mangleName();
	}
} // SymTab

#endif // MANGLER_H

// Local Variables: //
// tab-width: 4 //
// mode: c++ //
// compile-command: "make install" //
// End: //
