//
// Cforall Version 1.0.0 Copyright (C) 2015 University of Waterloo
//
// The contents of this file are covered under the licence agreement in the
// file "LICENCE" distributed with Cforall.
//
// IdTable.h -- 
//
// Author           : Richard C. Bilson
// Created On       : Sun May 17 21:30:02 2015
// Last Modified By : Peter A. Buhr
// Last Modified On : Tue May 19 16:49:33 2015
// Update Count     : 4
//

#ifndef IDTABLE_H
#define IDTABLE_H

#include <iostream>
#include <map>
#include <string>
#include <stack>

#include "SynTree/SynTree.h"

namespace SymTab {
	class IdTable {
	  public:
		IdTable();
  
		void enterScope();
		void leaveScope();
		void addDecl( DeclarationWithType *decl );
		void lookupId( const std::string &id, std::list< DeclarationWithType* >& decls ) const;
		DeclarationWithType* lookupId( const std::string &id) const;
  
		void dump( std::ostream &os ) const;			// debugging
	  private:
		typedef std::pair< DeclarationWithType*, int > DeclEntry;
		typedef std::map< std::string, std::stack< DeclEntry > > InnerTableType;
		typedef std::map< std::string, InnerTableType > OuterTableType;

		OuterTableType table;
		int scopeLevel;
	};
} // namespace SymTab

#endif // IDTABLE_H

// Local Variables: //
// tab-width: 4 //
// mode: c++ //
// compile-command: "make install" //
// End: //
