# set terminal pdfcairo size 6,3
# BUILD = "build/"
set terminal pslatex size 6.25,2.5 color solid

# RUNTIME #
set output BUILD."cfa-time.tex"

set xlabel "\\textsc{cfa-co} runtime (ms)"
set ylabel "runtime (ms)"
set logscale xy
set key outside

plot for [i=2:6] 'evaluation/cfa-time.tsv' using 2:i title columnheader

# MEMORY #
set output BUILD."cfa-mem.tex"

set ylabel "peak memory (MB)"

plot for [i=2:6] 'evaluation/cfa-mem-by-time.tsv' using 7:(column(i)/1000) title columnheader

# # RUNTIME SPEEDUP #
# set output BUILD."cfa-speedup.pdf"

# set ylabel "time factor of cfa-co"
# unset logscale y

# plot for [i=2:6] 'evaluation/cfa-time.tsv' using 2:(column(i)/column(2)) title columnheader

# # MEMORY SPEEDUP #
# set output BUILD."cfa-mem-speedup.pdf"

# set ylabel "peak memory factor of cfa-co"
# unset logscale y

# plot for [i=2:6] 'evaluation/cfa-mem-by-time.tsv' using 7:(column(i)/column(2)) title columnheader
