//
// Cforall Version 1.0.0 Copyright (C) 2015 University of Waterloo
//
// The contents of this file are covered under the licence agreement in the
// file "LICENCE" distributed with Cforall.
//
// iostream.c -- 
//
// Author           : Richard C. Bilson
// Created On       : Wed May 27 17:56:53 2015
// Last Modified By : Peter A. Buhr
// Last Modified On : Fri Nov 20 13:19:19 2015
// Update Count     : 9
//

#include "iostream.h"
extern "C" {
#include <stdio.h>
#include <string.h>										// strlen
}

forall( dtype ostype | ostream( ostype ) )
ostype * ?<<?( ostype *os, char c ) {
	return write( os, &c, 1 );
} // ?<<?

forall( dtype ostype | ostream( ostype ) )
ostype * ?<<?( ostype *os, int i ) {
	char buffer[32];									// larger than the largest integer
	sprintf( buffer, "%d", i );
	return write( os, buffer, strlen( buffer ) );
} // ?<<?

forall( dtype ostype | ostream( ostype ) )
ostype * ?<<?( ostype *os, double d ) {
	char buffer[32];									// larger than the largest double
	sprintf( buffer, "%g", d );
	return write( os, buffer, strlen( buffer ) );
} // ?<<?

forall( dtype ostype | ostream( ostype ) )
ostype * ?<<?( ostype *os, const char *cp ) {
	return write( os, cp, strlen( cp ) );
} // ?<<?

forall( dtype ostype | ostream( ostype ) )
ostype * ?<<?( ostype *os, const void *p ) {
	char buffer[32];									// larger than the largest pointer
	sprintf( buffer, "%p", p );
	return write( os, buffer, strlen( buffer ) );
} // ?<<?

forall( type elt_type | writeable( elt_type ),
		type iterator_type | iterator( iterator_type, elt_type ),
		dtype os_type | ostream( os_type ) )
void write( iterator_type begin, iterator_type end, os_type *os ) {
	void print( elt_type i ) {
		os << i << ' ';
	}
	for_each( begin, end, print );
} // ?<<?

forall( type elt_type | writeable( elt_type ),
		type iterator_type | iterator( iterator_type, elt_type ),
		dtype os_type | ostream( os_type ) )
void write_reverse( iterator_type begin, iterator_type end, os_type *os ) {
	void print( elt_type i ) {
		os << i << ' ';
	}
	for_each_reverse( begin, end, print );
} // ?<<?


forall( dtype istype | istream( istype ) )
istype * ?>>?( istype *is, char *cp ) {
	return read( is, cp, 1 );
} // ?>>?

forall( dtype istype | istream( istype ) )
istype * ?>>?( istype *is, int *ip ) {
	char cur;
  
	// skip some whitespace
	do {
		is >> &cur;
		if ( fail( is ) || eof( is ) ) return is;
	} while ( !( cur >= '0' && cur <= '9' ) );
  
	// accumulate digits
	*ip = 0;
	while ( cur >= '0' && cur <= '9' ) {
		*ip = *ip * 10 + ( cur - '0' );
		is >> &cur;
		if ( fail( is ) || eof( is ) ) return is;
	}
  
	unread( is, cur );
	return is;
} // ?>>?

// Local Variables: //
// tab-width: 4 //
// compile-command: "cfa iostream.c" //
// End: //
