//
// Cforall Version 1.0.0 Copyright (C) 2015 University of Waterloo
//
// The contents of this file are covered under the licence agreement in the
// file "LICENCE" distributed with Cforall.
//
// GenPoly.h -- 
//
// Author           : Richard C. Bilson
// Created On       : Mon May 18 07:44:20 2015
// Last Modified By : Peter A. Buhr
// Last Modified On : Thu Nov 19 17:24:03 2015
// Update Count     : 4
//

#ifndef GENPOLY_H
#define GENPOLY_H

#include <map>
#include <string>
#include <iostream>
#include "SynTree/Declaration.h"

namespace GenPoly {
	typedef std::map< std::string, TypeDecl::Kind > TyVarMap;

	bool needsAdapter( FunctionType *adaptee, const TyVarMap &tyVarr );
	bool isPolyRet( FunctionType *function, std::string &name, const TyVarMap &otherTyVars );
	bool isPolyRet( FunctionType *function, std::string &name );
	bool isPolyRet( FunctionType *function, const TyVarMap &otherTyVars );
//	bool isPolyFun( FunctionType *fun, const TyVarMap &tyVars );
	bool isPolyVal( Type *type, const TyVarMap &tyVars );
	void printTyVarMap( std::ostream &os, const TyVarMap &tyVarMap );
} // namespace GenPoly

#endif // GENPOLY_H

// Local Variables: //
// tab-width: 4 //
// mode: c++ //
// compile-command: "make install" //
// End: //
