//
// Cforall Version 1.0.0 Copyright (C) 2015 University of Waterloo
//
// The contents of this file are covered under the licence agreement in the
// file "LICENCE" distributed with Cforall.
//
// ObjectDecl.cc --
//
// Author           : Richard C. Bilson
// Created On       : Mon May 18 07:44:20 2015
// Last Modified By : Peter A. Buhr
// Last Modified On : Thu Aug 18 23:50:33 2016
// Update Count     : 31
//

#include "Declaration.h"
#include "Type.h"
#include "Initializer.h"
#include "Expression.h"
#include "Attribute.h"
#include "Common/utility.h"
#include "Statement.h"

ObjectDecl::ObjectDecl( const std::string &name, DeclarationNode::StorageClass sc, LinkageSpec::Spec linkage, Expression *bitfieldWidth, Type *type, Initializer *init, const std::list< Attribute * > attributes, bool isInline, bool isNoreturn )
	: Parent( name, sc, linkage, attributes ), type( type ), init( init ), bitfieldWidth( bitfieldWidth ) {
	set_isInline( isInline );
	set_isNoreturn( isNoreturn );
}

ObjectDecl::ObjectDecl( const ObjectDecl &other )
	: Parent( other ), type( maybeClone( other.type ) ), init( maybeClone( other.init ) ), bitfieldWidth( maybeClone( other.bitfieldWidth ) ) {
}

ObjectDecl::~ObjectDecl() {
	delete type;
	delete init;
	delete bitfieldWidth;
}

void ObjectDecl::print( std::ostream &os, int indent ) const {
	if ( get_name() != "" ) {
		os << get_name() << ": ";
	} // if

	if ( get_linkage() != LinkageSpec::Cforall ) {
		os << LinkageSpec::toString( get_linkage() ) << " ";
	} // if

	printAll( get_attributes(), os, indent );

	if ( get_storageClass() != DeclarationNode::NoStorageClass ) {
		os << DeclarationNode::storageName[ get_storageClass() ] << ' ';
	} // if

	if ( get_type() ) {
		get_type()->print( os, indent );
	} else {
		os << " untyped entity ";
	} // if

	if ( init ) {
		os << " with initializer ";
		init->print( os, indent );
		os << std::endl << std::string(indent, ' ');
		os << "maybeConstructed? " << init->get_maybeConstructed();
	} // if

	if ( bitfieldWidth ) {
		os << std::string(indent, ' ');
		os << " with bitfield width ";
		bitfieldWidth->print( os );
	} // if
}

void ObjectDecl::printShort( std::ostream &os, int indent ) const {
#if 0
	if ( get_mangleName() != "") {
		os << get_mangleName() << ": ";
	} else
#endif
	if ( get_name() != "" ) {
		os << get_name() << ": ";
	} // if

	// xxx - should printShort print attributes?

	if ( get_storageClass() != DeclarationNode::NoStorageClass ) {
		os << DeclarationNode::storageName[ get_storageClass() ] << ' ';
	} // if

	if ( get_type() ) {
		get_type()->print( os, indent );
	} else {
		os << "untyped entity ";
	} // if

	if ( bitfieldWidth ) {
		os << "with bitfield width ";
		bitfieldWidth->print( os );
	} // if
}

// Local Variables: //
// tab-width: 4 //
// mode: c++ //
// compile-command: "make install" //
// End: //
