//
// Cforall Version 1.0.0 Copyright (C) 2016 University of Waterloo
//
// The contents of this file are covered under the licence agreement in the
// file "LICENCE" distributed with Cforall.
//
// CtxSwitch-x86_64.S --
//
// Author           : Thierry Delisle
// Created On       : Mon Nov 28 12:27:26 2016
// Last Modified By : Peter A. Buhr
// Last Modified On : Fri Jul 21 22:28:11 2017
// Update Count     : 1
//
// This  library is free  software; you  can redistribute  it and/or  modify it
// under the terms of the GNU Lesser General Public License as published by the
// Free Software  Foundation; either  version 2.1 of  the License, or  (at your
// option) any later version.
//
// This library is distributed in the  hope that it will be useful, but WITHOUT
// ANY  WARRANTY;  without even  the  implied  warranty  of MERCHANTABILITY  or
// FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License
// for more details.
//
// You should  have received a  copy of the  GNU Lesser General  Public License
// along  with this library.
//

// This context switch routine depends on the fact that the stack of a new
// thread has been set up to look like the thread has saved its context in
// the normal manner.
//
// void CtxSwitch( machine_context *from, machine_context *to );

// Offsets in the context structure. This needs to be synchronized with the
// high level code a little better.

#define PTR_BYTE	8
#define SP_OFFSET	( 0 * PTR_BYTE )
#define FP_OFFSET	( 1 * PTR_BYTE )

//-----------------------------------------------------------------------------
// Regular context switch routine which enables switching from one context to anouther
	.text
	.align 2
	.globl CtxSwitch
	.type  CtxSwitch, @function
CtxSwitch:

	// Save volatile registers on the stack.

	pushq %r15
	pushq %r14
	pushq %r13
	pushq %r12
	pushq %rbx

	// Save old context in the "from" area.

	movq %rsp,SP_OFFSET(%rdi)
	movq %rbp,FP_OFFSET(%rdi)

	// Load new context from the "to" area.

	movq SP_OFFSET(%rsi),%rsp
	movq FP_OFFSET(%rsi),%rbp

	// Load volatile registers from the stack.

	popq %rbx
	popq %r12
	popq %r13
	popq %r14
	popq %r15

	// Return to thread.

	ret
	.size  CtxSwitch, .-CtxSwitch

//-----------------------------------------------------------------------------
// Part of a 2 part context switch routine, use with CtxRet, stores the current context and then makes a function call
	.text
	.align 2
	.globl CtxStore
	.type  CtxStore, @function
CtxStore:

	// Save volatile registers on the stack.

	pushq %r15
	pushq %r14
	pushq %r13
	pushq %r12
	pushq %rbx

	// Save old context in the "from" area.

	movq %rsp,SP_OFFSET(%rdi)
	movq %rbp,FP_OFFSET(%rdi)

	// Don't load a new context, directly jump to the desired function

	jmp *%rsi
	.size  CtxStore, .-CtxStore

//-----------------------------------------------------------------------------
// Part of a 2 part context switch routine, use with CtxStore, context switches to the desired target without saving the current context
	.text
	.align 2
	.globl CtxRet
	.type  CtxRet, @function
CtxRet:
	// Load new context from the "to" area.

	movq SP_OFFSET(%rdi),%rsp
	movq FP_OFFSET(%rdi),%rbp

	// Load volatile registers from the stack.

	popq %rbx
	popq %r12
	popq %r13
	popq %r14
	popq %r15

	// Return to thread.

	ret
	.size  CtxRet, .-CtxRet


//-----------------------------------------------------------------------------
// Stub used to create new stacks which are ready to be context switched to
	.text
	.align 2
	.globl CtxInvokeStub
	.type	 CtxInvokeStub, @function
CtxInvokeStub:
	movq %rbx, %rdi
	jmp *%r12
	.size  CtxInvokeStub, .-CtxInvokeStub

// Local Variables: //
// mode: c //
// tab-width: 4 //
// End: //
