#include "VbyteSM.h" 
#include "tools.h"

void AddThisAfter(HandleNode_t* const this, HandleNode_t* n)
{
	this->next = n->next;
	this->previous = n;
	HandleNode_t* n_next = n->next;
	n_next->previous = this;
	n->next = this;
}

void DeleteNode(HandleNode_t* const this)
{
	HandleNode_t* next = this->next;
	HandleNode_t* prev = this->previous;

	next->previous = prev;
	prev->next = next;
}

void MoveThisAfter(HandleNode_t* const this, const HandleNode_t* rhs)
{
	assertf( this->string < rhs->string, 
	"VbyteSM: Error - Cannot move byte string starting at: %lX after byte string starting at: %lX and keep handles in ascending order",
	(unsigned long int)this->string, 
	(unsigned long int)rhs->string);

	HandleNode_t* i;
	for(i = rhs->next; 
	    i->string && this->string > i->string; 
	    i = i->next );

	if( this != i->previous )
	{
		DeleteNode(this);
		AddThisAfter(this, i->previous);
	}
}
