// 
// Cforall Version 1.0.0 Copyright (C) 2016 University of Waterloo
//
// The contents of this file are covered under the licence agreement in the
// file "LICENCE" distributed with Cforall.
// 
// math2.c -- 
// 
// Author           : Peter A. Buhr
// Created On       : Fri Apr 22 14:59:21 2016
// Last Modified By : Peter A. Buhr
// Last Modified On : Fri Aug 11 15:40:04 2017
// Update Count     : 81
// 

#include <fstream>
#include <math>

int main( void ) {
	float f;
	double d;
	long double l;

	//---------------------- Trigonometric ----------------------

	sout | "sin:" | sin( 1.0F ) | sin( 1.0D ) | sin( 1.0L ) | sin( 1.0F+1.0FI ) | sin( 1.0D+1.0DI ) | sin( 1.0DL+1.0LI ) | endl;
	sout | "cos:" | cos( 1.0F ) | cos( 1.0D ) | cos( 1.0L ) | cos( 1.0F+1.0FI ) | cos( 1.0D+1.0DI ) | cos( 1.0DL+1.0LI ) | endl;
	sout | "tan:" | tan( 1.0F ) | tan( 1.0D ) | tan( 1.0L ) | tan( 1.0F+1.0FI ) | tan( 1.0D+1.0DI ) | tan( 1.0DL+1.0LI ) | endl;
	sout | "asin:" | asin( 1.0F ) | asin( 1.0D ) | asin( 1.0L ) | asin( 1.0F+1.0FI ) | asin( 1.0D+1.0DI ) | asin( 1.0DL+1.0LI ) | endl;
	sout | "acos:" | acos( 1.0F ) | acos( 1.0D ) | acos( 1.0L ) | acos( 1.0F+1.0FI ) | acos( 1.0D+1.0DI ) | acos( 1.0DL+1.0LI ) | endl;
	sout | "atan:" | atan( 1.0F ) | atan( 1.0D ) | atan( 1.0L ) | atan( 1.0F+1.0FI ) | atan( 1.0D+1.0DI ) | atan( 1.0DL+1.0LI ) | endl;
	sout | "atan2:" | atan2( 1.0F, 1.0F ) | atan2( 1.0D, 1.0D ) | atan2( 1.0L, 1.0L );
	sout | "atan:" | atan( 1.0F, 1.0F ) | atan( 1.0D, 1.0D ) | atan( 1.0L, 1.0L ) | endl;

	//---------------------- Hyperbolic ----------------------

	sout | "sinh:" | sinh( 1.0F ) | sinh( 1.0D ) | sinh( 1.0L ) | sinh( 1.0F+1.0FI ) | sinh( 1.0D+1.0DI ) | sinh( 1.0DL+1.0LI ) | endl;
	sout | "cosh:" | cosh( 1.0F ) | cosh( 1.0D ) | cosh( 1.0L ) | cosh( 1.0F+1.0FI ) | cosh( 1.0D+1.0DI ) | cosh( 1.0DL+1.0LI ) | endl;
	sout | "tanh:" | tanh( 1.0F ) | tanh( 1.0D ) | tanh( 1.0L ) | tanh( 1.0F+1.0FI ) | tanh( 1.0D+1.0DI ) | tanh( 1.0DL+1.0LI ) | endl;
	sout | "acosh:" | acosh( 1.0F ) | acosh( 1.0D ) | acosh( 1.0L ) | acosh( 1.0F+1.0FI ) | acosh( 1.0D+1.0DI ) | acosh( 1.0DL+1.0LI ) | endl;
	sout | "asinh:" | asinh( 1.0F ) | asinh( 1.0D ) | asinh( 1.0L ) | asinh( 1.0F+1.0FI ) | asinh( 1.0D+1.0DI ) | asinh( 1.0DL+1.0LI ) | endl;
	sout | "atanh:" | atanh( 1.0F ) | atanh( 1.0D ) | atanh( 1.0L ) | atanh( 1.0F+1.0FI ) | atanh( 1.0D+1.0DI ) | atanh( 1.0DL+1.0LI ) | endl;

	//---------------------- Error / Gamma ----------------------

	sout | "erf:" | erf( 1.0F ) | erf( 1.0D ) | erf( 1.0L ) | endl;
	sout | "erfc:" | erfc( 1.0F ) | erfc( 1.0D ) | erfc( 1.0L ) | endl;
	sout | "lgamma:" | lgamma( 4.0F ) | lgamma( 4.0D ) | lgamma( 4.0L ) | endl;
	int sign;
	f = lgamma( 4.0F, &sign );
	sout | "lgamma:" | f | sign;
	d = lgamma( 4.0D, &sign );
	sout | d | sign;
	l = lgamma( 4.0L, &sign );
	sout | l | sign | endl;
	sout | "tgamma:" | tgamma( 4.0F ) | tgamma( 4.0D ) | tgamma( 4.0L ) | endl;
} // main

// Local Variables: //
// tab-width: 4 //
// compile-command: "cfa math2.c" //
// End: //
