//
// Cforall Version 1.0.0 Copyright (C) 2015 University of Waterloo
//
// The contents of this file are covered under the licence agreement in the
// file "LICENCE" distributed with Cforall.
//
// Mangler.h --
//
// Author           : Richard C. Bilson
// Created On       : Sun May 17 21:44:03 2015
// Last Modified By : Peter A. Buhr
// Last Modified On : Sat Jul 22 09:45:30 2017
// Update Count     : 15
//

#pragma once

#include <map>                // for map, map<>::value_compare
#include <sstream>            // for ostringstream
#include <string>             // for string
#include <utility>            // for pair

#include "SynTree/SynTree.h"  // for Types
#include "SynTree/Visitor.h"  // for Visitor, maybeAccept

namespace SymTab {
	namespace Mangler {
		/// Mangle syntax tree object; primary interface to clients
		std::string mangle( BaseSyntaxNode * decl, bool mangleOverridable = true, bool typeMode = false, bool mangleGenericParams = true );

		/// Mangle a type name; secondary interface
		std::string mangleType( Type* ty );
		/// Mangle ignoring generic type parameters
		std::string mangleConcrete( Type* ty );
	} // Mangler
} // SymTab

// Local Variables: //
// tab-width: 4 //
// mode: c++ //
// compile-command: "make install" //
// End: //
