//
// Cforall Version 1.0.0 Copyright (C) 2015 University of Waterloo
//
// The contents of this file are covered under the licence agreement in the
// file "LICENCE" distributed with Cforall.
//
// CodeLocation.h --
//
// Author           : Andrew Beach
// Created On       : Thr Aug 17 11:23:00 2017
// Last Modified By : Peter A. Buhr
// Last Modified On : Mon Aug 28 12:46:01 2017
// Update Count     : 2
//

#pragma once

#include <iostream>
#include <string>

struct CodeLocation {
	int linenumber;
	std::string filename;

	/// Create a new unset CodeLocation.
		CodeLocation()
		: linenumber( -1 )
		, filename("")
	{}

	/// Create a new CodeLocation with the given values.
	CodeLocation( const char* filename, int lineno )
		: linenumber( lineno )
		, filename(filename ? filename : "")
	{}

	CodeLocation( const CodeLocation& rhs ) = default;

	bool isSet () const {
		return -1 != linenumber;
	}

	bool isUnset () const {
		return !isSet();
	}

	bool followedBy( CodeLocation const & other, int seperation ) {
		return (linenumber + seperation == other.linenumber &&
		        filename == other.filename);
	}

	bool operator==( CodeLocation const & other ) {
		return followedBy( other, 0 );
	}

	bool operator!=( CodeLocation const & other ) {
		return !(*this == other);
	}
};

inline std::ostream & operator<<( std::ostream & out, const CodeLocation & location ) {
	// Column number ":1" allows IDEs to parse the error message and position the cursor in the source text.
	return location.isSet() ? out << location.filename << ":" << location.linenumber << ":1 " : out;
}
