//
// Cforall Version 1.0.0 Copyright (C) 2015 University of Waterloo
//
// The contents of this file are covered under the licence agreement in the
// file "LICENCE" distributed with Cforall.
//
// poly-bench.cc -- 
//
// Author           : Aaron Moss
// Created On       : Sat May 16 07:26:30 2015
// Last Modified By : Peter A. Buhr
// Last Modified On : Wed May 27 18:25:19 2015
// Update Count     : 5
//

extern "C" {
#include <stdio.h>
//#include "my_time.h"
}

#define N 200000000

struct ipoint {
	int x;
	int y;
};

struct ipoint ?+?(struct ipoint a, struct ipoint b) {
	struct ipoint r;
	r.x = a.x + b.x;
	r.y = a.y + b.y;
	return r;
}

struct ipoint ?-?(struct ipoint a, struct ipoint b) {
	struct ipoint r;
	r.x = a.x - b.x;
	r.y = a.y - b.y;
	return r;
}

struct ipoint ?*?(struct ipoint a, struct ipoint b) {
	struct ipoint r;
	r.x = a.x * b.x;
	r.y = a.y * b.y;
	return r;
}

struct dpoint {
	double x;
	double y;
};

struct dpoint ?+?(struct dpoint a, struct dpoint b) {
	struct dpoint r;
	r.x = a.x + b.x;
	r.y = a.y + b.y;
	return r;
}

struct dpoint ?-?(struct dpoint a, struct dpoint b) {
	struct dpoint r;
	r.x = a.x - b.x;
	r.y = a.y - b.y;
	return r;
}

struct dpoint ?*?(struct dpoint a, struct dpoint b) {
	struct dpoint r;
	r.x = a.x * b.x;
	r.y = a.y * b.y;
	return r;
}

int a2b2_mono_int(int a, int b) {
	return (a - b)*(a + b);
}

double a2b2_mono_double(double a, double b) {
	return (a - b)*(a + b);
}

struct ipoint a2b2_mono_ipoint(struct ipoint a, struct ipoint b) {
	return (a - b)*(a + b);
}

struct dpoint a2b2_mono_dpoint(struct dpoint a, struct dpoint b) {
	return (a - b)*(a + b);
}

forall(type T | { T ?+?(T,T); T ?-?(T,T); T ?*?(T,T); })
T a2b2_poly(T a, T b) {
	return (a - b)*(a + b);
}

typedef int clock_t;
long ms_between(clock_t start, clock_t end) {
//	return (end - start) / (CLOCKS_PER_SEC / 1000);
	return 0;
}
int clock() { return 3; }

int main(int argc, char** argv) {
	clock_t start, end;
	int i;
	
	int a, b;
	double c, d;
	struct ipoint p, q;
	struct dpoint r, s;
	
	printf("\n## a^2-b^2 ##\n");
	
	a = 5, b = 3;
	start = clock();
	for (i = 0; i < N/2; ++i) {
		a = a2b2_mono_int(a, b);
		b = a2b2_mono_int(b, a);
	}
	end = clock();
	printf("mono_int:   %7ld  [%d,%d]\n", ms_between(start, end), a, b);
	
	a = 5, b = 3;
	start = clock();
	for (i = 0; i < N/2; ++i) {
		a = a2b2_poly(a, b);
		b = a2b2_poly(b, a);
	}
	end = clock();
	printf("poly_int:   %7ld  [%d,%d]\n", ms_between(start, end), a, b);
	
/*	{
	a = 5, b = 3;
	// below doesn't actually work; a2b2_poly isn't actually assigned, just declared
	* [int] (int, int) a2b2_poly = a2b2_mono_int;
	start = clock();
	for (i = 0; i < N/2; ++i) {
//			printf("\t[%d,%d]\n", a, b);
a = a2b2_poly(a, b);
//			printf("\t[%d,%d]\n", a, b);
b = a2b2_poly(b, a);
}
end = clock();
printf("spec_int:   %7ld  [%d,%d]\n", ms_between(start, end), a, b);
}
*/	
	c = 5.0, d = 3.0;
	start = clock();
	for (i = 0; i < N/2; ++i) {
		c = a2b2_mono_double(c, d);
		d = a2b2_mono_double(d, c);
	}
	end = clock();
	printf("mono_double:%7ld  [%f,%f]\n", ms_between(start, end), c, d);
		
	c = 5.0, d = 3.0;
	start = clock();
	for (i = 0; i < N/2; ++i) {
		c = a2b2_poly(c, d);
		d = a2b2_poly(d, c);
	}
	end = clock();
	printf("poly_double:%7ld  [%f,%f]\n", ms_between(start, end), c, d);
	
	p.x = 5, p.y = 5, q.x = 3, q.y = 3;
	start = clock();
	for (i = 0; i < N/2; ++i) {
		p = a2b2_mono_ipoint(p, q);
		q = a2b2_mono_ipoint(q, p);
	}
	end = clock();
	printf("mono_ipoint:%7ld  [(%d,%d),(%d,%d)]\n", ms_between(start, end), p.x, p.y, q.x, q.y);
		
	p.x = 5, p.y = 5, q.x = 3, q.y = 3;
	start = clock();
	for (i = 0; i < N/2; ++i) {
		p = a2b2_poly(p, q);
		q = a2b2_poly(q, p);
	}
	end = clock();
	printf("poly_ipoint:%7ld  [(%d,%d),(%d,%d)]\n", ms_between(start, end), p.x, p.y, q.x, q.y);
	
	r.x = 5.0, r.y = 5.0, s.x = 3.0, s.y = 3.0;
	start = clock();
	for (i = 0; i < N/2; ++i) {
		r = a2b2_mono_dpoint(r, s);
		s = a2b2_mono_dpoint(s, r);
	}
	end = clock();
	printf("mono_dpoint:%7ld  [(%f,%f),(%f,%f)]\n", ms_between(start, end), r.x, r.y, s.x, s.y);
		
	r.x = 5.0, r.y = 5.0, s.x = 3.0, s.y = 3.0;
	start = clock();
	for (i = 0; i < N/2; ++i) {
		r = a2b2_poly(r, s);
		s = a2b2_poly(s, r);
	}
	end = clock();
	printf("poly_dpoint:%7ld  [(%f,%f),(%f,%f)]\n", ms_between(start, end), r.x, r.y, s.x, s.y);

	return 0;
}

// Local Variables: //
// tab-width: 4 //
// compile-command: "cfa poly-bench.c" //
// End: //
