// 
// Cforall Version 1.0.0 Copyright (C) 2016 University of Waterloo
//
// The contents of this file are covered under the licence agreement in the
// file "LICENCE" distributed with Cforall.
// 
// math.c -- 
// 
// Author           : Peter A. Buhr
// Created On       : Fri Apr 22 14:59:21 2016
// Last Modified By : Peter A. Buhr
// Last Modified On : Sun Apr 24 13:24:20 2016
// Update Count     : 70
// 

#include <fstream>
#include <math>

int main( void ) {
	float f;
	double d;
	long double l;

	sout | "fabs:" | fabs( -1.0F ) | fabs( -1.0D ) | fabs( -1.0L ) | cabs( -1.0F+1.0FI ) | cabs( -1.0D+1.0DI ) | cabs( -1.0DL+1.0LI ) | endl;
	sout | "fmod:" | 5.0F % -2.0F | fmod( 5.0F, -2.0F ) | 5.0D % -2.0D | fmod( 5.0D, -2.0D ) | 5.0L % -2.0L | fmod( 5.0L, -2.0L ) | endl;
	sout | "remainder:" | remainder( 2.0F, 3.0F ) | remainder( 2.0D, 3.0D ) | remainder( 2.0L, 3.0L ) | endl;
	int quot;
	f = remquo( 3.6F, 0.5F, &quot );
	sout | "remquo:" | quot | f;
	d = remquo( 3.6D, 0.5F, &quot );
	sout | quot | d;
	l = remquo( 3.6L, 0.5L, &quot );
	sout | quot | l | endl;
	f = div( 3.6F, 0.5F, &quot );
	sout | "div:" | quot | f;
	d = div( 3.6D, 0.5F, &quot );
	sout | quot | d;
	l = div( 3.6L, 0.5L, &quot );
	sout | quot | l | endl;
	sout | "fma:" | fma( 3.0F, -1.0F, 1.0F ) | fma( 3.0D, -1.0D, 1.0D ) | fma( 3.0L, -1.0L, , 1.0L ) | endl;
	sout | "fdim:" | fdim( 1.0F, -1.0F ) | fdim( 1.0D, -1.0D ) | fdim( 1.0L, -1.0L ) | endl;
	sout | "nan:" | (float)nan( "" ) | (double)nan( "" ) | (long double)nan( "" ) | endl;

	//---------------------- Exponential ----------------------

	sout | "exp:" | exp( 1.0F ) | exp( 1.0D ) | exp( 1.0L ) | exp( 1.0F+1.0FI ) | exp( 1.0D+1.0DI ) | exp( 1.0DL+1.0LI ) | endl;
	sout | "exp2:" | exp2( 1.0F ) | exp2( 1.0D ) | exp2( 1.0L ) | endl;
	sout | "expm1:" | expm1( 1.0F ) | expm1( 1.0D ) | expm1( 1.0L ) | endl;
	sout | "log:" | log( 1.0F ) | log( 1.0D ) | log( 1.0L ) | log( 1.0F+1.0FI ) | log( 1.0D+1.0DI ) | log( 1.0DL+1.0LI ) | endl;
	sout | "log2:" | log2( 8.0F ) | log2( 8.0D ) | log2( 8.0L ) | endl;
	sout | "log10:" | log10( 100.0F ) | log10( 100.0D ) | log10( 100.0L ) | endl;
	sout | "log1p:" | log1p( 1.0F ) | log1p( 1.0D ) | log1p( 1.0L ) | endl;
	sout | "ilogb:" | ilogb( 1.0F ) | ilogb( 1.0D ) | ilogb( 1.0L ) | endl;
	sout | "logb:" | logb( 8.0F ) | logb( 8.0D ) | logb( 8.0L ) | endl;

	//---------------------- Power ----------------------

	sout | "sqrt:" | sqrt( 1.0F ) | sqrt( 1.0D ) | sqrt( 1.0L ) | sqrt( 1.0F+1.0FI ) | sqrt( 1.0D+1.0DI ) | sqrt( 1.0DL+1.0LI ) | endl;
	sout | "cbrt:" | cbrt( 27.0F ) | cbrt( 27.0D ) | cbrt( 27.0L ) | endl;
	sout | "hypot:" | hypot( 1.0F, -1.0F ) | hypot( 1.0D, -1.0D ) | hypot( 1.0L, -1.0L ) | endl;
	sout | "pow:" | pow( 1.0F, 1.0F ) | pow( 1.0D, 1.0D ) | pow( 1.0L, 1.0L ) | pow( 1.0F+1.0FI, 1.0F+1.0FI ) | pow( 1.0D+1.0DI, 1.0D+1.0DI ) | pow( 1.0DL+1.0LI, 1.0DL+1.0LI ) | endl;

	//---------------------- Trigonometric ----------------------

	sout | "sin:" | sin( 1.0F ) | sin( 1.0D ) | sin( 1.0L ) | sin( 1.0F+1.0FI ) | sin( 1.0D+1.0DI ) | sin( 1.0DL+1.0LI ) | endl;
	sout | "cos:" | cos( 1.0F ) | cos( 1.0D ) | cos( 1.0L ) | cos( 1.0F+1.0FI ) | cos( 1.0D+1.0DI ) | cos( 1.0DL+1.0LI ) | endl;
	sout | "tan:" | tan( 1.0F ) | tan( 1.0D ) | tan( 1.0L ) | tan( 1.0F+1.0FI ) | tan( 1.0D+1.0DI ) | tan( 1.0DL+1.0LI ) | endl;
	sout | "asin:" | asin( 1.0F ) | asin( 1.0D ) | asin( 1.0L ) | asin( 1.0F+1.0FI ) | asin( 1.0D+1.0DI ) | asin( 1.0DL+1.0LI ) | endl;
	sout | "acos:" | acos( 1.0F ) | acos( 1.0D ) | acos( 1.0L ) | acos( 1.0F+1.0FI ) | acos( 1.0D+1.0DI ) | acos( 1.0DL+1.0LI ) | endl;
	sout | "atan:" | atan( 1.0F ) | atan( 1.0D ) | atan( 1.0L ) | atan( 1.0F+1.0FI ) | atan( 1.0D+1.0DI ) | atan( 1.0DL+1.0LI ) | endl;
	sout | "atan2:" | atan2( 1.0F, 1.0F ) | atan2( 1.0D, 1.0D ) | atan2( 1.0L, 1.0L );
	sout | "atan:" | atan( 1.0F, 1.0F ) | atan( 1.0D, 1.0D ) | atan( 1.0L, 1.0L );

	//---------------------- Hyperbolic ----------------------

	sout | "sinh:" | sinh( 1.0F ) | sinh( 1.0D ) | sinh( 1.0L ) | sinh( 1.0F+1.0FI ) | sinh( 1.0D+1.0DI ) | sinh( 1.0DL+1.0LI ) | endl;
	sout | "cosh:" | cosh( 1.0F ) | cosh( 1.0D ) | cosh( 1.0L ) | cosh( 1.0F+1.0FI ) | cosh( 1.0D+1.0DI ) | cosh( 1.0DL+1.0LI ) | endl;
	sout | "tanh:" | tanh( 1.0F ) | tanh( 1.0D ) | tanh( 1.0L ) | tanh( 1.0F+1.0FI ) | tanh( 1.0D+1.0DI ) | tanh( 1.0DL+1.0LI ) | endl;
	sout | "acosh:" | acosh( 1.0F ) | acosh( 1.0D ) | acosh( 1.0L ) | acosh( 1.0F+1.0FI ) | acosh( 1.0D+1.0DI ) | acosh( 1.0DL+1.0LI ) | endl;
	sout | "asinh:" | asinh( 1.0F ) | asinh( 1.0D ) | asinh( 1.0L ) | asinh( 1.0F+1.0FI ) | asinh( 1.0D+1.0DI ) | asinh( 1.0DL+1.0LI ) | endl;
	sout | "atanh:" | atanh( 1.0F ) | atanh( 1.0D ) | atanh( 1.0L ) | atanh( 1.0F+1.0FI ) | atanh( 1.0D+1.0DI ) | atanh( 1.0DL+1.0LI ) | endl;

	//---------------------- Error / Gamma ----------------------

	sout | "erf:" | erf( 1.0F ) | erf( 1.0D ) | erf( 1.0L ) | endl;
	sout | "erfc:" | erfc( 1.0F ) | erfc( 1.0D ) | erfc( 1.0L ) | endl;
	sout | "lgamma:" | lgamma( 4.0F ) | lgamma( 4.0D ) | lgamma( 4.0L ) | endl;
	int sign;
	f = lgamma( 4.0F, &sign );
	sout | "lgamma:" | f | sign;
	d = lgamma( 4.0D, &sign );
	sout | d | sign;
	l = lgamma( 4.0L, &sign );
	sout | l | sign | endl;
	sout | "tgamma:" | tgamma( 4.0F ) | tgamma( 4.0D ) | tgamma( 4.0L ) | endl;

	//---------------------- Nearest Integer ----------------------

	sout | "floor:" | floor( 1.2F ) | floor( 1.2D ) | floor( 1.2L ) | endl;
	sout | "ceil:" | ceil( 1.6F ) | ceil( 1.6D ) | ceil( 1.6L ) | endl;
	sout | "trunc:" | trunc( 3.5F ) | trunc( 3.5D ) | trunc( 3.5L ) | endl;
	sout | "rint:" | (float)rint( 1.5F ) | (double)rint( 1.5D ) | (long double)rint( 1.5L ) | endl;
	sout | "rint:" | (long int)rint( 1.5F ) | (long int)rint( 1.5D ) | (long int)rint( 1.5L ) | endl;
	sout | "rint:" | (long long int)rint( 1.5F ) | (long long int)rint( 1.5D ) | (long long int)rint( 1.5L ) | endl;
	sout | "lrint:" | lrint( 1.5F ) | lrint( 1.5D ) | lrint( 1.5L ) | endl;
	sout | "llrint:" | llrint( 1.5F ) | llrint( 1.5D ) | llrint( 1.5L ) | endl;
	sout | "nearbyint:" | nearbyint( 3.5F ) | nearbyint( 3.5D ) | nearbyint( 3.5L ) | endl;
	sout | "round:" | (float)round( 1.5F ) | (double)round( 1.5D ) | (long double)round( 1.5L ) | endl;
	sout | "round:" | (long int)round( 1.5F ) | (long int)round( 1.5D ) | (long int)round( 1.5L ) | endl;
	sout | "round:" | (long long int)round( 1.5F ) | (long long int)round( 1.5D ) | (long long int)round( 1.5L ) | endl;
	sout | "lround:" | lround( 1.5F ) | lround( 1.5D ) | lround( 1.5L ) | endl;
	sout | "llround:" | llround( 1.5F ) | llround( 1.5D ) | llround( 1.5L ) | endl;

	//---------------------- Manipulation ----------------------

	sout | "copysign:" | copysign( 1.0F, -1.0F ) | copysign( 1.0D, -1.0D ) | copysign( 1.0L, -1.0L ) | endl;
	int exp;
	f = frexp( 4.0F, &exp );
	sout | "frexp:" | f | exp;
	d = frexp( 4.0D, &exp );
	sout | d | exp;
	l = frexp( 4.0L, &exp );
	sout | l | exp | endl;
	sout | "ldexp:" | ldexp( 2.0F, 2 ) | ldexp( 2.0D, 2 ) | ldexp( 2.0L, 2 ) | endl;
	float fi;
	double di;
	long double ldi;
	f = modf( 2.3F, &fi );
	sout | "modf:" | fi | f;
	d = modf( 2.3D, &di );
	sout | di | d;
	l = modf( 2.3L, &ldi );
	sout | ldi | l;
	sout | "nextafter:" | nextafter( 2.0F, 3.0F ) | nextafter( 2.0D, 3.0D ) | nextafter( 2.0L, 3.0L ) | endl;
	sout | "nexttoward:" | nexttoward( 2.0F, 3.0F ) | nexttoward( 2.0D, 3.0D ) | nexttoward( 2.0L, 3.0L ) | endl;

	sout | "scalbn:" | scalbn( 2.0F, 3 ) | scalbn( 2.0D, 3 ) | scalbn( 2.0L, 3 ) | endl;
	sout | "scalbln:" | scalbln( 2.0F, 3L ) | scalbln( 2.0D, 3L ) | scalbln( 2.0L, 3L ) | endl;
} // main

// Local Variables: //
// tab-width: 4 //
// compile-command: "cfa math.c" //
// End: //
