//
// Cforall Version 1.0.0 Copyright (C) 2015 University of Waterloo
//
// The contents of this file are covered under the licence agreement in the
// file "LICENCE" distributed with Cforall.
//
// TypedefTable.h --
//
// Author           : Peter A. Buhr
// Created On       : Sat May 16 15:24:36 2015
// Last Modified By : Peter A. Buhr
// Last Modified On : Mon May 21 20:28:01 2018
// Update Count     : 76
//

#pragma once

#include <string>										// for string

#include "Common/ScopedMap.h"							// for ScopedMap
#include "ParserTypes.h"
#include "parser.hh"									// for IDENTIFIER, TYPEDEFname, TYPEGENname

class TypedefTable {
  public:
	enum kind_t { ID = IDENTIFIER, TD = TYPEDEFname, TG = TYPEGENname };
  private:
	typedef ScopedMap< std::string, kind_t > KindTable;
	KindTable kindTable;	
  public:
	~TypedefTable();

	bool exists( const std::string & identifier );
	int isKind( const std::string & identifier ) const;
	void changeKind( const std::string & identifier, kind_t kind );
	void makeTypedef( const std::string & name );
	void addToEnclosingScope( const std::string & identifier, kind_t kind );

	void enterScope();
	void leaveScope();
}; // TypedefTable

// Local Variables: //
// tab-width: 4 //
// mode: c++ //
// compile-command: "make install" //
// End: //
