//
// Cforall Version 1.0.0 Copyright (C) 2015 University of Waterloo
//
// The contents of this file are covered under the licence agreement in the
// file "LICENCE" distributed with Cforall.
//
// TypedefTable.cc -- 
//
// Author           : Peter A. Buhr
// Created On       : Sat May 16 15:20:13 2015
// Last Modified By : Peter A. Buhr
// Last Modified On : Mon May 21 20:55:24 2018
// Update Count     : 117
//


#include "TypedefTable.h"
#include <cassert>               // for assert

#if 0
#include <iostream>
#define debugPrint( x ) cerr << x
#else
#define debugPrint( x )
#endif

using namespace std;

TypedefTable::~TypedefTable() {
	if ( ! SemanticErrorThrow && kindTable.currentScope() != 0 ) {
		// std::cerr << "scope failure " << kindTable.currentScope() << endl;
	} // if
} // TypedefTable::~TypedefTable

bool TypedefTable::exists( const string & identifier ) {
	return kindTable.find( identifier ) != kindTable.end();
} // TypedefTable::exists

int TypedefTable::isKind( const string & identifier ) const {
	// Name lookup defaults to identifier, and then the identifier's kind is set by the parser.
	KindTable::const_iterator posn = kindTable.find( identifier );
	if ( posn == kindTable.end() ) return IDENTIFIER;
	return posn->second;
} // TypedefTable::isKind

void TypedefTable::changeKind( const string & identifier, kind_t kind ) {
	KindTable::iterator posn = kindTable.find( identifier );
	if ( posn != kindTable.end() ) posn->second = kind;
} // TypedefTable::changeKind

// SKULLDUGGERY: Generate a typedef for the aggregate name so the aggregate does not have to be qualified by
// "struct". Only generate the typedef, if the name is not in use. The typedef is implicitly (silently) removed if the
// name is explicitly used.
void TypedefTable::makeTypedef( const string & name ) {
	if ( ! typedefTable.exists( name ) ) {
		typedefTable.addToEnclosingScope( name, TypedefTable::TD );
	} // if
} // TypedefTable::makeTypedef

void TypedefTable::addToEnclosingScope( const std::string & identifier, kind_t kind ) {
	assert( kindTable.currentScope() >= 1 );
	auto scope = kindTable.currentScope() - 1;
	debugPrint( "Adding " << identifier << " as kind " << kind << " scope " << scope << endl );
	auto ret = kindTable.insertAt( scope, identifier, kind );
	if ( ! ret.second ) { // already an element there
		ret.first->second = kind; // update existing element with new kind
	} // if
} // TypedefTable::addToEnclosingScope

void TypedefTable::enterScope() {
	kindTable.beginScope();
	debugPrint( "Entering scope " << kindTable.currentScope() << endl );
} // TypedefTable::enterScope

void TypedefTable::leaveScope() {
	debugPrint( "Leaving scope " << kindTable.currentScope() << endl );
	kindTable.endScope();
} // TypedefTable::leaveScope

// void TypedefTable::print( void ) const {
// 	for ( KindTable::const_iterator i = table.begin(); i != table.end(); i++) {
// 		debugPrint( (*i ).first << ": " );
// 		list< Entry > declList = (*i).second;
// 		for ( list< Entry >::const_iterator j = declList.begin(); j != declList.end(); j++ ) {
// 			debugPrint( "(" << (*j).scope << " " << (*j).kind << ") " );
// 		}
// 		debugPrint( endl );
// 	} // for
// }

// Local Variables: //
// tab-width: 4 //
// mode: c++ //
// compile-command: "make install" //
// End: //
