//
// Cforall Version 1.0.0 Copyright (C) 2016 University of Waterloo
//
// The contents of this file are covered under the licence agreement in the
// file "LICENCE" distributed with Cforall.
//
// vector.c --
//
// Author           : Thierry Delisle
// Created On       : Tue Jul  5 18:07:52 2016
// Last Modified By : Peter A. Buhr
// Last Modified On : Tue Jul  5 18:08:31 2016
// Update Count     : 2
//

#include <containers/vector>

#include <stdlib>

//------------------------------------------------------------------------------
//Initialization
forall(otype T, otype allocator_t | allocator_c(T, allocator_t))
void ctor(vector(T, allocator_t) *const this)
{
	ctor(&this->storage);
	this->size = 0;
}

forall(otype T, otype allocator_t | allocator_c(T, allocator_t))
void dtor(vector(T, allocator_t) *const this)
{
	clear(this);
	dtor(&this->storage);
}

//------------------------------------------------------------------------------
//Modifiers
forall(otype T, otype allocator_t | allocator_c(T, allocator_t))
void push_back(vector(T, allocator_t) *const this, T value)
{
	realloc_storage(&this->storage, this->size+1);
	data(&this->storage)[this->size] = value;
	this->size++;
}

forall(otype T, otype allocator_t | allocator_c(T, allocator_t))
void pop_back(vector(T, allocator_t) *const this)
{
	this->size--;
	DESTROY(data(&this->storage)[this->size]);
}

forall(otype T, otype allocator_t | allocator_c(T, allocator_t))
void clear(vector(T, allocator_t) *const this)
{
	for(size_t i = 0; i < this->size; i++)
	{
		DESTROY(data(&this->storage)[this->size]);
	}
	this->size = 0;
}

//------------------------------------------------------------------------------
//Allocator
forall(otype T)
void ctor(heap_allocator(T) *const this)
{
	this->storage = 0;
	this->capacity = 0;
}

forall(otype T)
void dtor(heap_allocator(T) *const this)
{
	free(this->storage);
}

forall(otype T)
inline void realloc_storage(heap_allocator(T) *const this, size_t size)
{
	enum { GROWTH_RATE = 2 };
	if(size > this->capacity)
	{
		this->capacity = GROWTH_RATE * size;
		this->storage = (T*)realloc((void*)this->storage, this->capacity * sizeof(T));
	}
}

// Local Variables: //
// mode: c //
// tab-width: 4 //
// End: //
