//
// Cforall Version 1.0.0 Copyright (C) 2015 University of Waterloo
//
// The contents of this file are covered under the licence agreement in the
// file "LICENCE" distributed with Cforall.
//
// RemoveInit.cc -- 
//
// Author           : Rodolfo G. Esteves
// Created On       : Mon May 18 07:44:20 2015
// Last Modified By : Peter A. Buhr
// Last Modified On : Tue May 19 16:39:32 2015
// Update Count     : 1
//

#include "RemoveInit.h"
#include "SynTree/Declaration.h"
#include "SynTree/Type.h"
#include "SynTree/Expression.h"
#include "SynTree/Statement.h"
#include "SynTree/Initializer.h"
#include "SynTree/Mutator.h"

namespace InitTweak {
	namespace {
		const std::list<Label> noLabels;
	}

	void tweak( std::list< Declaration * > translationUnit ) {
		RemoveInit remover;
		mutateAll( translationUnit, remover );
	}

	void RemoveInit::mutateStatementList( std::list< Statement* > &statements ) {
		for ( std::list< Statement* >::iterator i = statements.begin(); i != statements.end(); ++i ) {
			if ( ! stmtsToAddAfter.empty() ) {
				statements.splice( i, stmtsToAddAfter );
			} // if
			*i = (*i)->acceptMutator( *this );
		} // for
		if ( ! stmtsToAddAfter.empty() ) {
			statements.splice( statements.end(), stmtsToAddAfter );
		} // if
	}

	CompoundStmt *RemoveInit::mutate(CompoundStmt *compoundStmt) {
		mutateStatementList( compoundStmt->get_kids() );
		return compoundStmt;
	}

// in the case where an object has an initializer and a polymorphic type, insert an assignment
// immediately after the declaration. This will (seemingly) cause the later phases to do the right
// thing with the assignment
	ObjectDecl *RemoveInit::mutate( ObjectDecl *objDecl ) {
		if (objDecl->get_init() && dynamic_cast<TypeInstType*>(objDecl->get_type())) {
			if (SingleInit * single = dynamic_cast<SingleInit*>(objDecl->get_init())) {
				UntypedExpr *assign = new UntypedExpr( new NameExpr( "?=?" ) );
				assign->get_args().push_back( new AddressExpr (new NameExpr( objDecl->get_name() ) ) );
				assign->get_args().push_back( single->get_value()->clone() );
				stmtsToAddAfter.push_back(new ExprStmt(noLabels, assign));
			} // if
		} // if
		return objDecl;
	}
} // namespace InitTweak

// Local Variables: //
// tab-width: 4 //
// mode: c++ //
// compile-command: "make install" //
// End: //
