//
// Cforall Version 1.0.0 Copyright (C) 2019 University of Waterloo
//
// The contents of this file are covered under the licence agreement in the
// file "LICENCE" distributed with Cforall.
//
// AssertAcyclic.cpp -- Check that ast::ptr does not form a cycle.
//
// Author           : Andrew Beach
// Created On       : Thu Jun 06 15:00:00 2019
// Last Modified By : Andrew Beach
// Last Modified On : Thu Jun 06 15:00:00 2019
// Update Count     : 0
//

#include "AssertAcyclic.hpp"

#include "AST/Pass.hpp"

namespace {

class NoStrongCyclesCore : public ast::WithGuards {
    std::vector<const ast::Node *> parents;
public:
	void previsit ( const ast::Node * node ) {
		for (auto & p : parents) {
			assert(p != node);
		}
		parents.push_back(node);
		GuardAction( [this]() { parents.pop_back(); } );
	}
};

}

namespace ast {

void assertAcyclic( const std::list< ast::ptr< ast::Decl > > translationUnit ) {
   	Pass<NoStrongCyclesCore> visitor;
	for ( auto & decl : translationUnit ) {
		decl->accept( visitor );
	}
}

}

// Local Variables: //
// tab-width: 4 //
// mode: c++ //
// compile-command: "make install" //
// End: //
