#![feature(async_await)]

use std::thread;
use std::sync::mpsc;

fn main() {
	let (tx1, rx1) = mpsc::channel();
	let (tx2, rx2) = mpsc::channel();
	let (tx3, rx3) = mpsc::channel();
	let (tx4, rx4) = mpsc::channel();
	struct Msg { i : i64,  j : i64 }
	let th = thread::spawn( || {
		let i : i64; let f : f64; let m : Msg;
		loop {
			select! {
				i = rx1.recv() => println( i );
				f = rx2.recv() => println( f );
				m = rx3.recv() => println( m );
				_ = rx4.recv() => break;
			}
		}
	});

	tx1.send( 0 ); // different messages
	tx2.send( 2.5 );
	tx3.send( Msg { i:1, j:2 } );
	tx4.send( "done" );
	th.join().unwrap();
}

// Local Variables: //
// tab-width: 4 //
// compile-command: "rustc -C opt-level=3 channels.rs" //
// End: //
