#!/bin/bash

##############################################################################
#
# Cforall Version 1.0.0 Copyright (C) 2015 University of Waterloo
#
# The contents of this file are covered under the licence agreement in the
# file "LICENCE" distributed with Cforall.
#
# Runs integration tests for cfa-cc.
#
# Output of test run will be copied into $logfile (default: tests/log.txt).
# Build failures for tests will be placed in tests/$test.make.txt, incorrect
# output in tests/$test.run.txt.
#
# Author           : Aaron B. Moss
# Created On       : Mon Nov 23 14:19:00 2015
# Last Modified By : Aaron B. Moss
# Last Modified On : Mon Nov 23 14:19:00 2015
# Update Count     : 1
#
##############################################################################

# list of tests to run;
# Should be a make target for each test that generates an executable in the
# current directory named the same; should also be an input file
# tests/$test.in.txt and expected output tests/$test.out.txt
# tests="vector_test avl_test"
#
# # log file for test output;
# # reset at the beginning of each run
# logfile=tests/log.txt
# touch $logfile && rm $logfile
#
# # clean existing build artifacts before run
# make clean > /dev/null 2>&1
#
# ret_val=0
#
# for test in $tests; do
# 	echo -n "    $test" | tee -a $logfile
#
# 	# build, skipping to next test on error
# 	if ! make -j 8 $test > tests/$test.make.txt 2>&1; then
# 		ret_val=1
# 		echo -e "\tFAILED with build error:" | tee -a $logfile
# 		cat tests/$test.make.txt | tee -a $logfile
# 		continue
# 	fi
# 	rm tests/$test.make.txt
#
# 	# run, testing against expected output
# 	./$test < tests/$test.in.txt > tests/$test.run.txt 2>&1
# 	if ! diff tests/$test.out.txt tests/$test.run.txt > tests/$test.diff.txt; then
# 		ret_val=1
# 		echo -e "\tFAILED with output mismatch:" | tee -a $logfile
# 		cat tests/$test.diff.txt | tee -a $logfile
# 		continue
# 	fi
# 	rm tests/$test.run.txt tests/$test.diff.txt ./$test
#
# 	echo -e "\tPASSED" | tee -a $logfile
# done
#
# exit $((ret_val))

tests="vector_test avl_test"

python test.py ${tests}

ret_val=$?
exit $((ret_val))
