#include <stdbool.h>
#include <stdio.h>

#include "bench.h"

#define thread_local _Thread_local

volatile thread_local bool value;

void __attribute__((noinline)) do_call() {
	__atomic_store_n( &value, true, __ATOMIC_RELAXED );
	__atomic_signal_fence(__ATOMIC_ACQUIRE);
	asm volatile ("");
	__atomic_store_n( &value, false, __ATOMIC_RELAXED );
	__atomic_signal_fence(__ATOMIC_RELEASE);
}

int main(int argc, char* argv[]) {
	BENCH(
		for (size_t i = 0; i < n; i++) {
			do_call();
		},
		result
	)

	printf("%llu\n", result);
}
