#include "bench.h"
#include "cfa-stack.h"
#include "cfa-pair.h"

int main( int argc, char * argv[] ) {
	int max = 0, val = 42;
	stack( int ) si, ti;

	REPEAT_TIMED( "push_int", N, push( si, val ); )
	TIMED( "copy_int", ti = si; )
	TIMED( "clear_int", clear( si ); )
	REPEAT_TIMED( "pop_int", N, 
		int x = pop( ti ); if ( x > max ) max = x; )

	pair( _Bool, char ) max = { (_Bool)0 /***/, '\0' }, val = { (_Bool)1 /***/, 'a' };
	stack( pair( _Bool, char ) ) sp, tp;

	REPEAT_TIMED( "push_pair", N, push( sp, val ); )
	TIMED( "copy_pair", tp = sp; )
	TIMED( "clear_pair", clear( sp ); )
	REPEAT_TIMED( "pop_pair", N,
		pair(_Bool, char) x = pop( tp ); if ( x > max ) max = x; )
}
