#pragma once

#include "object.hpp"

class stack {
	struct node {
		ptr<object> value;
		node* next;

		node( const object& v );

		node( ptr<object>&& v, node* n );
	};

	node* head;

	void copy(const stack& o);

public:
	void clear();

	stack();

	stack(const stack& o);

	stack(stack&& o);

	~stack();

	stack& operator= (const stack& o);
	
	stack& operator= (stack&& o);

	bool empty() const;

	void push(ptr<object>&& value);

	ptr<object> pop();
};
