#include <stdlib>
#include <stdio.h>
#include "pair"
#include "bench.h"
#include "cfa-stack.h"
#include "cfa-print.h"

int main( int argc, char *argv[] ) {
	FILE * out = fopen( "cfa-out.txt", "w" );
	int max = 0;
	stack(int) s, t;
	REPEAT_TIMED( "push_int", push( &s, _i ); )
	TIMED( "copy_int", t = s; )
	TIMED( "clear_int", clear( &s ); )
	REPEAT_TIMED( "pop_int", max = max( max, pop( &t ) ); )
	REPEAT_TIMED( "print_int", print( out, _i, ":", _i, "\n" ); )

	stack(pair(_Bool, char)) s1, t1;
	pair(_Bool, char) max = { (_Bool)0, '\0' };
	REPEAT_TIMED( "push_pair", push( &s1, (pair(_Bool, char)){ _i & 1, _i &0x7F } ); )
	TIMED( "copy_pair", t1 = s1; )
	TIMED( "clear_pair", clear( &s1 ); )
	REPEAT_TIMED( "pop_pair", max = max( max, pop( &t1 ) ); )
	REPEAT_TIMED( "print_pair",
		 print( out, (pair(_Bool, char)){  _i & 1, _i &0x7F }, ":", (pair(_Bool, char)){  _i & 1, _i &0x7F }, "\n" ); )
	fclose(out);
}