#include <algorithm>
#include <fstream>
#include <utility>
#include "bench.hpp"
#include "cpp-stack.hpp"
#include "cpp-print.hpp"

int main(int argc, char** argv) {
	std::ofstream out{"cpp-out.txt"};
	stack<int> s, t;
	int max = 0;
	REPEAT_TIMED( "push_int", s.push( _i ); )
	TIMED( "copy_int", t = s; )
	TIMED( "clear_int", s.clear(); )
	REPEAT_TIMED( "pop_int", max = std::max( max, t.pop() ); )
	print( out, max, "\n" );
	REPEAT_N_TIMED( "print_int", N/2, print( out, _i, ":", _i, "\n" ); )

	stack<std::pair<bool, char>> s1, t1;
	std::pair<bool, char> max1 = { false, '\0' };
	REPEAT_TIMED( "push_bool_char", s1.push( std::pair<bool, char>{ _i & 0x1, _i & 0x7F } ); )
	TIMED( "copy_bool_char", t1 = s1; )
	TIMED( "clear_bool_char", s1.clear(); )
	REPEAT_TIMED( "pop_bool_char", max1 = std::max( max1, t1.pop() ); )
	print( out, max1, "\n" );
	REPEAT_N_TIMED( "print_pair", N/2, 
		print( out, std::pair<bool, char>{ _i & 0x1, _i & 0x7F }, ":",
				std::pair<bool, char>{ _i & 0x1, _i & 0x7F }, "\n" ); )
}