//
// Cforall Version 1.0.0 Copyright (C) 2015 University of Waterloo
//
// The contents of this file are covered under the licence agreement in the
// file "LICENCE" distributed with Cforall.
//
// ScrubTyVars.h -- 
//
// Author           : Richard C. Bilson
// Created On       : Mon May 18 07:44:20 2015
// Last Modified By : Peter A. Buhr
// Last Modified On : Tue May 19 07:48:14 2015
// Update Count     : 1
//

#ifndef _SCRUBTYVARS_H
#define _SCRUBTYVARS_H

#include <string>

#include "GenPoly.h"

#include "SynTree/SynTree.h"
#include "SynTree/Mutator.h"

namespace GenPoly {
	class ScrubTyVars : public Mutator {
	  public:
		ScrubTyVars( bool doAll, const TyVarMap &tyVars ): doAll( doAll ), tyVars( tyVars ) {}

		/// Like scrub( SynTreeClass* ), but only applies to type variables in `tyVars`
		template< typename SynTreeClass >
		static SynTreeClass *scrub( SynTreeClass *target, const TyVarMap &tyVars );
		/// Replaces dtypes and ftypes with the appropriate void type, and sizeof expressions of polymorphic types with the proper variable
		template< typename SynTreeClass >
		static SynTreeClass *scrub( SynTreeClass *target );
  
		virtual Type* mutate( TypeInstType *typeInst );
		Expression* mutate( SizeofExpr *szeof );
		Expression* mutate( AlignofExpr *algnof );
		virtual Type* mutate( PointerType *pointer );
	  private:
		bool doAll;
		const TyVarMap &tyVars;
	};

	/* static class method */
	template< typename SynTreeClass >
	SynTreeClass * ScrubTyVars::scrub( SynTreeClass *target, const TyVarMap &tyVars ) {
		ScrubTyVars scrubber( false, tyVars );
		return static_cast< SynTreeClass * >( target->acceptMutator( scrubber ) );
	}

	/* static class method */
	template< typename SynTreeClass >
	SynTreeClass * ScrubTyVars::scrub( SynTreeClass *target ) {
		TyVarMap tyVars;
		ScrubTyVars scrubber( true, tyVars );
		return static_cast< SynTreeClass* >( target->acceptMutator( scrubber ) );
	}

	/// Gets the name of the sizeof parameter for the type
	std::string sizeofName( Type *ty );

	/// Gets the name of the alignof parameter for the type
	std::string alignofName( Type *ty );
} // namespace GenPoly

#endif // _SCRUBTYVARS_H

// Local Variables: //
// tab-width: 4 //
// mode: c++ //
// compile-command: "make install" //
// End: //
