
#ifndef _INVOKE_H_
#define _INVOKE_H_

struct coVtable {
      void (*main)(void*);
      struct coroutine* (*this_coroutine)(void*);
};

struct coStack_t {
      unsigned int size;		// size of stack
      void *storage;			// pointer to stack
      void *limit;			// stack grows towards stack limit
      void *base;				// base of stack
      void *context;			// address of cfa_context_t
      void *top;				// address of top of storage
      bool userStack;	
};


enum coroutine_state { Start, Inactive, Active, Halt };

struct coroutine {
      struct coStack_t stack;
      const char *name;			// textual name for coroutine/task, initialized by uC++ generated code
      int errno_;				// copy of global UNIX variable errno
      enum coroutine_state state;	      // current execution status for coroutine
      bool notHalted;			// indicate if execuation state is not halted

      struct coroutine *starter;		// first coroutine to resume this one
      struct coroutine *last;			// last coroutine to resume this one
};

#endif //_INVOKE_H_